<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$installer->addAttribute("catalog_product", "elasticsearch_index", [
    "group"            => "ElasticSearch",
    "label"            => "Index",
    "type"             => "int",
    "input"            => "select",
    "source"           => "eav/entity_attribute_source_boolean",
    "default"          => "1",
    "required"         => true,
    "visible_on_front" => false,
    "filterable"       => false,
    "searchable"       => false,
    "comparable"       => false,
    "user_defined"     => false,
    "is_configurable"  => false,
    "global"           => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_STORE,
    "note"             => "If the product should be indexed in ElasticSearch",
    "position"         => 10,
]);

$installer->addAttribute("catalog_product", "elasticsearch_limit_customers", [
    "group"            => "ElasticSearch",
    "label"            => "Limit to customers",
    "type"             => "varchar",
    "input"            => "text",
    "default"          => "",
    "required"         => true,
    "visible_on_front" => false,
    "filterable"       => false,
    "searchable"       => false,
    "comparable"       => false,
    "user_defined"     => false,
    "is_configurable"  => false,
    "global"           => Mage_Catalog_Model_Resource_Eav_Attribute::SCOPE_GLOBAL,
    "note"             => "Comma-separated list of customer ids this product is only visible for",
    "position"         => 20,
]);

$installer->endSetup();
