<?php

class Crossroads_Elasticsearch_Model_Observer {
    public function addAttributeBoostField($observer) {
        $form     = $observer->getForm();
        $fieldset = $form->getElement("front_fieldset");

        $fieldset->addField("crossroads_elasticsearch_boost", "text", [
            "name"  => "crossroads_elasticsearch_boost",
            "label" => "ElasticSearch Boost factor",
            "note"  => "Boosts result matches in this field by the specified factor, integers of 1 and larger are allowed",
        ]);

        $fieldset->addField("crossroads_elasticsearch_operator", "select", [
            "name"  => "crossroads_elasticsearch_operator",
            "label" => "ElasticSearch Value Combination Operator",
            "note"  => "Boolean operator used to combine multiple filters on the same attribute. This also affects the behaviour of facets where the AND filter will exclude items which do not match while the OR filter will still include them.",
            "required" => true,
            "options"  => [
                "must"   => "AND (excluding)",
                "should" => "OR (including)",
            ],
        ])->setAfterElementHtml(<<<'END'
<script type="text/javascript">
document.observe("dom:loaded", function(){
  // Copied from  app/design/adminhtml/default/default/template/catalog/product/attribute/js.phtml
  if($('frontend_input') && ($('frontend_input').value=='select' || $('frontend_input').value=='multiselect' || $('frontend_input').value=='price')){
    if($("crossroads_elasticsearch_operator")) {
      $("crossroads_elasticsearch_operator").disabled = false;
    }
  }
  else {
    if($("crossroads_elasticsearch_operator")) {
      $("crossroads_elasticsearch_operator").selectedIndex = 0;
      $("crossroads_elasticsearch_operator").disabled = true;
    }
  }
});
</script>
END
);
        $fieldset->addField("crossroads_elasticsearch_autocomplete", "select", [
            "name"    => "crossroads_elasticsearch_autocomplete",
            "label"   => "ElasticSearch Autocomplete",
            "note"    => "If this field should be used in search autocomplete",
            "options" => Mage::getSingleton("adminhtml/system_config_source_yesno")->toArray(),
        ])->setAfterElementHtml(<<<'END'
<script type="text/javascript">
document.observe("dom:loaded", function() {
  function update() {
    if($('is_searchable').value == 1 ||
       $('is_visible_in_advanced_search').value == 1 ||
       $('is_filterable').value == 1 ||
       $('is_filterable_in_search').value == 1) {
      $("crossroads_elasticsearch_autocomplete").disabled = false;
    }
    else {
      $("crossroads_elasticsearch_autocomplete").selectedIndex = 0;
      $("crossroads_elasticsearch_autocomplete").disabled = true;
    }
  }

  $('is_searchable').observe('change', update);
  $('is_visible_in_advanced_search').observe('change', update);
  $('is_filterable').observe('change', update);
  $('is_filterable_in_search').observe('change', update);

  update();
});
</script>
END
);

        $fieldset->addField("crossroads_elasticsearch_min_cardinality", "text", [
            "name"  => "crossroads_elasticsearch_min_cardinality",
            "label" => "ElasticSearch Minimum Facet Cardinality",
            "note"  => "Percentage of products in the results which need to have a value in the attribute for its facet to be displayed. Integers from 0 up to and including 100.",
            "required" => true,
        ])->setAfterElementHtml(<<<'END'
<script type="text/javascript">
document.observe("dom:loaded", function() {
  var el = $("crossroads_elasticsearch_min_cardinality");

  el.observe("change", function() {
    if(el.value < 0 || el.value > 100) {
      el.value = Math.max(0, Math.min(100, el.value));
    }
  });

  // Copied from  app/design/adminhtml/default/default/template/catalog/product/attribute/js.phtml
  if($('frontend_input') && ($('frontend_input').value=='select' || $('frontend_input').value=='multiselect' || $('frontend_input').value=='price')){
    $("crossroads_elasticsearch_min_cardinality").disabled = false;
  }
  else {
    $("crossroads_elasticsearch_min_cardinality").selectedIndex = 0;
    $("crossroads_elasticsearch_min_cardinality").disabled = true;
  }
});
</script>
END
);

        $fieldset->addField("crossroads_elasticsearch_expanded", "select", [
            "name"  => "crossroads_elasticsearch_expanded",
            "label" => "ElasticSearch Expand Facet",
            "note"  => "If to expand the facet by default",
            "options" => Mage::getSingleton("adminhtml/system_config_source_yesno")->toArray(),
        ])->setAfterElementHtml(<<<'END'
<script type="text/javascript">
document.observe("dom:loaded", function() {
  // Copied from  app/design/adminhtml/default/default/template/catalog/product/attribute/js.phtml
  if($('frontend_input') && ($('frontend_input').value=='select' || $('frontend_input').value=='multiselect' || $('frontend_input').value=='price')){
    $("crossroads_elasticsearch_expanded").disabled = false;
  }
  else {
    $("crossroads_elasticsearch_expanded").selectedIndex = 0;
    $("crossroads_elasticsearch_expanded").disabled = true;
  }
});
</script>
END
);

        $fieldset->addField("crossroads_elasticsearch_max_options", "text", [
            "name"  => "crossroads_elasticsearch_max_options",
            "label" => "ElasticSearch Facet Max Options",
            "note"  => "The maximum number of options to display in an expanded facet. Integers from 1 up to and including 20.",
            "required" => true,
        ])->setAfterElementHtml(<<<'END'
<script type="text/javascript">
document.observe("dom:loaded", function() {
  var el = $("crossroads_elasticsearch_max_options");

  el.observe("change", function() {
    if(el.value < 1) {
      el.value = 1;
    }
  });

  // Copied from  app/design/adminhtml/default/default/template/catalog/product/attribute/js.phtml
  if($('frontend_input') && ($('frontend_input').value=='select' || $('frontend_input').value=='multiselect' || $('frontend_input').value=='price')){
    el.disabled = false;
  }
  else {
    el.selectedIndex = 0;
    el.disabled = true;
  }
});
</script>
END
);

    }
}
