<?php

class Crossroads_Elasticsearch_Model_CatalogSearch_Resource_Fulltext_Collection extends Mage_CatalogSearch_Model_Resource_Fulltext_Collection {
    protected $elasticsearchEnabled = false;
    protected $elasticsearchResults = null;
    protected $elasticsearchSortBy  = "relevance";
    protected $elasticsearchSortDir = "desc";

    protected function _construct() {
        parent::_construct();

        $helper = Mage::helper("Crossroads_Elasticsearch");

        $this->elasticsearchEnabled = $helper->enabledInStore([Mage_Catalog_Model_Product::ENTITY], Mage::app()->getStore());
    }

    public function addSearchFilter($query) {
        if( ! $this->elasticsearchEnabled) {
            // Fallback to original render
            return parent::addSearchFilter($query);
        }

        // TODO: Take category filters into account

        $model  = Mage::getModel("Crossroads_Elasticsearch/search");
        $client = Mage::helper("Crossroads_Elasticsearch")->createClient();

        $query = $model->setPage($this->getCurPage())
            ->setQueryString($query)
            ->setPageSize($this->_pageSize ?: Mage::getStoreConfig('catalog/frontend/grid_per_page'))
            ->addSort($this->elasticsearchSortBy, $this->elasticsearchSortDir);

        $this->elasticsearchResults = $client->search($query->createQuery());

        $productIds = array_map(function($h) { return $h["_id"]; }, $this->elasticsearchResults["hits"]["hits"]);

        $this->addFieldToFilter("entity_id", ["in"=> $productIds]);

        return $this;
    }

    public function setOrder($attribute, $dir = 'desc') {
        if( ! $this->elasticsearchEnabled) {
            return parent::setOrder($attribute, $dir);
        }

        $this->elasticsearchSortBy  = $attribute;
        $this->elasticsearchSortDir = $dir;

        return $this;
    }

    protected function _afterLoad() {
        if($this->elasticsearchResults) {
            $products = [];
            $items    = $this->_items;

            foreach($this->elasticsearchResults["hits"]["hits"] as $hit) {
                if(array_key_exists($hit["_id"], $items)) {
                    $products[] = $items[$hit["_id"]];
                }
            }

            $this->_items = $products;
        }

        return parent::_afterLoad();
    }
}
