<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$conn->addColumn($this->getTable("catalog/eav_attribute"), "crossroads_elasticsearch_min_cardinality", [
    "type"     => Varien_Db_Ddl_Table::TYPE_INTEGER,
    "nullable" => false,
    "default"  => 80,
    "comment"  => "Minimum percentage of products having values in the attribute for the attribute-facet to be visible"
]);

$conn->addColumn($this->getTable("catalog/eav_attribute"), "crossroads_elasticsearch_expanded", [
    "type"     => Varien_Db_Ddl_Table::TYPE_BOOLEAN,
    "nullable" => false,
    "default"  => false,
    "comment"  => "If the facet in filtered listings or search are expanded by default"
]);

$conn->addColumn($this->getTable("catalog/eav_attribute"), "crossroads_elasticsearch_max_options", [
    "type"     => Varien_Db_Ddl_Table::TYPE_INTEGER,
    "nullable" => false,
    "default"  => 10,
    "comment"  => "The default maximum number of options to provide in a facet when listing products"
]);

$installer->endSetup();
