<?php

class Crossroads_Elasticsearch_Model_Resource_Order extends Mage_Core_Model_Resource_Db_Abstract {
    protected function _construct() {
        $this->_setResource("core_read");
    }

    /**
     * Returns a list of SKUs for the given user id.
     *
     * @param  integer
     * @return Array<string>
     */
    public function getOrderHistory($userEntityId) {
        $sql = $this->getReadConnection();

        $select = $sql->select()
            ->from([ "sfo"  => $this->getTable("sales/order") ], [])
            ->join([ "sfoi" => $this->getTable("sales/order_item") ], "sfo.entity_id = sfoi.order_id", ["sku"])
            ->distinct(true)
            ->where("sfo.customer_id = ?", $userEntityId);

        return $sql->fetchCol($select);
    }
}
