<?php

abstract class Crossroads_Elasticsearch_Model_Resource_Abstract extends Mage_Core_Model_Resource_Db_Abstract {

    /**
     * Creates a query listing entity_id, store_id, website_id for all enabled and visible products.
     *
     * @param  Array<Mage_Core_Model_Store>
     * @param  Array<int>
     * @return Zend_Db_Select
     */
    public function createEntityIdStoreQuery($sql, $stores, $productIds = null) {
        $eavConfig             = Mage::getSingleton("eav/config");
        $statusAttr     = $eavConfig->getAttribute(Mage_Catalog_Model_Product::ENTITY, "status");
        $visibilityAttr = $eavConfig->getAttribute(Mage_Catalog_Model_Product::ENTITY, "visibility");
        $indexAttr      = $eavConfig->getAttribute(Mage_Catalog_Model_Product::ENTITY, "elasticsearch_index");

        // First fetch entities which are valid
        $select = $sql->select()
            // Start from status
            ->from(["s"     => $this->getValueTable("catalog/product", "int")], ["entity_id"])
            ->from(["store" => $this->getTable("core/store")], ["store_id", "website_id"])
            ->join(["w"     => $this->getTable("catalog/product_website")], "w.product_id = s.entity_id AND w.website_id = store.website_id", [])
            ->join(["v"     => $this->getValueTable("catalog/product", "int")], sprintf("v.entity_id = s.entity_id AND v.attribute_id = %d AND v.store_id = 0", $visibilityAttr->getAttributeId()), [])
            ->joinLeft(["i" => $this->getValueTable("catalog/product", "int")], sprintf("i.entity_id = s.entity_id AND i.attribute_id = %d AND i.store_id = 0", $indexAttr->getAttributeId()), [])
            ->joinLeft(["is" => $this->getValueTable("catalog/product", "int")], sprintf("is.entity_id = s.entity_id AND is.attribute_id = %d AND is.store_id = store.store_id", $indexAttr->getAttributeId()), [])
            ->joinLeft(["ss" => $this->getValueTable("catalog/product", "int")], sprintf("ss.entity_id = s.entity_id AND ss.attribute_id = %d AND ss.store_id = store.store_id", $statusAttr->getAttributeId()), [])
            ->joinLeft([ "sv" => $this->getValueTable("catalog/product", "int")], sprintf("sv.entity_id = s.entity_id AND sv.attribute_id = %d AND sv.store_id = store.store_id", $visibilityAttr->getAttributeId()), [])
            ->where("s.attribute_id = ?", $statusAttr->getAttributeId())
            ->where("s.store_id = 0 AND (s.value = ? AND ss.value IS NULL) OR ss.value = ?", Mage_Catalog_Model_Product_Status::STATUS_ENABLED)
            ->where("(i.value IS NULL OR i.value = '1') AND is.value IS NULL OR is.value = '1'")
            ->where("(v.value IN (?) AND sv.value IS NULL) OR sv.value IN (?)", [Mage_Catalog_Model_Product_Visibility::VISIBILITY_IN_SEARCH, Mage_Catalog_Model_Product_Visibility::VISIBILITY_BOTH, Mage_Catalog_Model_Product_Visibility::VISIBILITY_IN_CATALOG])
            ->where("store.store_id IN (?)", array_map(function($s) { return $s->getId(); }, $stores))
            ->columns([
                "visibility" => $sql->getIfNullSql(
                    $sql->quoteIdentifier("sv.value"),
                    $sql->quoteIdentifier("v.value")
                )
            ])
            ->group(["s.entity_id", "store.store_id"]);

        if($productIds) {
            $select = $select->where("p.entity_id IN (?)", $productIds);
        }

        return $select;
    }
}
