<?php

class Crossroads_Elasticsearch_Model_Query_Aggregation_Attribute {
    protected $params = [];
    protected $attrs  = [];

    protected $excludeQueryConstructor = null;

    public function setParameters($params) {
        $this->params = $params;

        return $this;
    }

    public function setAttributes($attributes) {
        $this->attrs = $attributes;

        return $this;
    }

    public function setExcludeQueryConstructor($fn) {
        $this->excludeQueryConstructor = $fn;

        return $this;
    }

    protected function buildExcludedFilterQuery($key) {
        if( ! is_callable($this->excludeQueryConstructor)) {
            throw new Exception("Missing query constructor");
        }

        $c = $this->excludeQueryConstructor;

        return $c($key);
    }

    public function toRequest() {
        $aggs = [];
        // TODO: Skip the filter for the aggregate count
        // TODO: Add categories

        // Facets are returned like:
        // aggregations -> key -> aggregations -> data -> { value, count }

        foreach($this->attrs as $attr) {
            if($attr->hasKeywordField()) {
                $aggs[$attr->getCode()] = [
                    "aggs" => [
                        // Got to nest since we want a filter still (of all the other attributes
                        // as well as stock status.
                        "data" => [
                            // This will be overriden in the OR case
                            "filter" => [ "match_all" => new stdClass ],
                            "aggs" => [
                                "values" => [ "terms" => [
                                    "field" => $attr->getKeywordField(),
                                    "size"  => $attr->getMaxOptions(),
                                ]],
                                // Aggregate number of hits on this aggregation
                                "count" => [ "value_count" => [
                                    "field" => $attr->getKeywordField(),
                                ]],
                            ],
                        ],
                    ],
                ];

                switch($attr->getOperator()) {
                case "must": // AND (exclude non-maches, reuse query)
                    // We do this to preserve the same structure as the OR case, a
                    // filter key is necessary even though we have it do nothing
                    $aggs[$attr->getCode()]["filter"] = [ "match_all" => new stdClass ];

                    break;
                case "should": // OR (include non-matches, create new query excluding self)
                    // We are filtering on it, so exclude it and apply the same filter
                    // as the query but without the key.
                    $aggs[$attr->getCode()]["data"]["filter"] = $this->buildExcludedFilterQuery($attr->getCode());

                    // Mark this one as global since we do not want to be affected by the
                    // query since the query already filters on values of this facet. The
                    // facet needs to be independent of the facet-filter to be able to
                    // produce results not matching the chosen facet-filter
                    $aggs[$attr->getCode()]["global"] = new stdClass;
                    break;
                }
            }

            // TODO: Integer ranges
            /*if($attr->isNumber()) {
                $aggs[$attr->getCode()] = [
                    "stats" => [
                        "field" => $attr->getCode()
                    ]
                ];
            }*/
        }

        return empty($aggs) ? new stdClass() : $aggs;
    }
}
