<?php

/**
 * Buffering batch-wrapper for ElasticSearch API.
 */
class Crossroads_Elasticsearch_Model_BatchManager {
    protected $batch_size = 500;

    protected $client;
    protected $errors = [];
    protected $size   = 0;
    protected $buffer = [];

    public function __construct($client, $batch_size = 100) {
        $this->client     = $client;
        $this->batch_size = $batch_size;
    }

    public function queue($header, $body = null) {
        $this->buffer[] = $header;

        if($body) {
            $this->buffer[] = $body;
        }

        $this->batch_size++;

        if($this->size >= $this->batch_size) {
            $this->sendBuffer();
        }
    }

    public function sendBuffer() {
        $resp = $this->client->bulk([ "body" => $this->buffer ]);

        if($resp["errors"]) {
            $this->errors = array_merge($this->errors, $resp["items"]);

            Mage::log("Crossroads_Elasticsearch: Failed to execute batch: ".print_r($resp, true), Zend_Log::ERR);

            return false;
        }

        $this->buffer = [];
        $this->size   = 0;

        return true;
    }

    public function getErrors() {
        return $this->errors;
    }

    public function hasErrors() {
        return empty($this->errors);
    }

    public function clear() {
        $this->buffer = [];
        $this->size   = 0;
        $this->errors = [];
    }
}
