<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("dynamiccategories/infoblock"))
    ->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity"       => true,
        "auto_increment" => true,
        "unsigned"       => true,
        "nullable"       => false,
        "primary"        => true,
    ], "Entity id")
    ->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        "unsigned" => true,
        "nullable" => false,
        "default"  => "0",
    ], "Store id this infoblock is tied to, will only be shown in that store, or in all if it is zero.")
    ->addColumn("enabled", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
        "nullable" => false,
        "default"  => false,
    ], "If it is visible to users or not")
    ->addColumn("name", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ], "Admin readable name for this info block")
    ->addColumn("title", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ], "Title for the info block, shown to the user")
    ->addColumn("heading", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ], "Heading for the info block, shown to user")
    ->addColumn("meta_title", Varien_Db_Ddl_Table::TYPE_TEXT, 160, [
        "nullable" => true,
    ], "Title used in meta tag")
    ->addColumn("meta_description", Varien_Db_Ddl_Table::TYPE_TEXT, 160, [
        "nullable" => true,
    ], "Description used in meta tag")
    ->addColumn("description", Varien_Db_Ddl_Table::TYPE_TEXT, null, [
        "nullable" => true
    ], "Description body in HTML for the info block.")
    ->addColumn("active_from", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => true,
    ], "Datetime this block is enabled, null means enable from beginning of time.")
    ->addColumn("active_to", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => true,
    ], "Datetime this block is disabled, null means enable to end of time.")
    ->addColumn("priority", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "nullable" => false,
        "default"  => 0,
    ], "Priority for this info block, if multiple blocks match the same conditions the one with the most matches wins, followed by the one with the highest priority")
    ->addColumn("created_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addColumn("updated_at", Varien_Db_Ddl_Table::TYPE_TIMESTAMP, null, [
        "nullable" => false,
        "default"  => Varien_Db_Ddl_Table::TIMESTAMP_INIT,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock",
            "store_id",
            "core/store",
            "store_id"
        ),
        "store_id", $installer->getTable("core/store"), "store_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$table = $conn->newTable($installer->getTable("dynamiccategories/infoblock_condition"))
    ->addColumn("entity_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity" => true,
        "unsigned" => true,
        "nullable" => false,
        "primary"  => true,
    ], "Entity id")
    ->addColumn("infoblock_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ], "Attribute ID")
    ->addColumn("attribute_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        "unsigned" => true,
        "nullable" => false,
    ], "Attribute ID")
    ->addColumn("attribute_option_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ], "Attribute value condition")
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock_condition",
            "infoblock_id",
            "dynamiccategories/infoblock",
            "entity_id"
        ),
        "infoblock_id", $installer->getTable("dynamiccategories/infoblock"), "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock_condition",
            "attribute_id",
            "eav/attribute",
            "attribute_id"
        ),
        "attribute_id", $installer->getTable('eav/attribute'), "attribute_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock_condition",
            "attribute_option_id",
            "eav/attribute_option",
            "option_id"
        ),
        "attribute_option_id", $installer->getTable("eav/attribute_option"), "option_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
