<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tab_Gallery_Widget extends Mage_Adminhtml_Block_Widget {
    protected $_uploaderType = "uploader/multiple";

    public function __construct() {
        parent::__construct();

        $this->setTemplate("crossroads_dynamiccategories/infoblock/gallery.phtml");
    }

    protected function _prepareLayout() {
        $this->setChild("uploader", $this->getLayout()->createBlock($this->_uploaderType));

        $this->getUploader()->getUploaderConfig()
            ->setFileParameterName("image")
            ->setTarget(Mage::getModel("adminhtml/url")->addSessionParam()->getUrl("*/dynamiccategories_infoblock_gallery/upload"));

        $browseConfig = $this->getUploader()->getButtonConfig();

        $browseConfig->setAttributes(["accept" => $browseConfig->getMimeTypesByExtensions("gif, png, jpeg, jpg")]);

        return parent::_prepareLayout();
    }

    public function getUploader() {
        return $this->getChild("uploader");
    }

    public function getUploaderHtml() {
        return $this->getChildHtml("uploader");
    }

    public function getJsObjectName() {
        return $this->getHtmlId() . "JsObject";
    }

    public function getAddImagesButton() {
        return $this->getButtonHtml(
            Mage::helper("catalog")->__("Add New Images"),
            $this->getJsObjectName() . ".showUploader()",
            "add",
            $this->getHtmlId() . "_add_images_button"
        );
    }

    public function getImagesJson() {
        return Mage::helper("core")->jsonEncode(array_values(array_map(function($img) {
            return [
                "value_id" => $img["value_id"],
                "file"     => $img["value"],
                "position" => 0,
                "removed"  => 0,
                "url"      => Mage::getSingleton("dynamiccategories/media_config")->getMediaUrl($img["value"]),
                "label"    => $img["label"],
            ];
        }, $this->getElement()->getValue())));
    }

    public function getImagesValuesJson() {
        $values = array();
        foreach ($this->getMediaAttributes() as $attribute) {
            /* @var $attribute Mage_Eav_Model_Entity_Attribute */
            $values[$attribute["code"]] = $this->getElement()->getDataObject()->getData(
                $attribute["code"]
            );
        }
        return Mage::helper("core")->jsonEncode($values);
    }

    public function getImageTypes() {
        // TODO: Remove
        $imageTypes = array();
        foreach ($this->getMediaAttributes() as $attribute) {
            $imageTypes[$attribute["code"]] = $attribute;
        }
        return $imageTypes;
    }

    public function getMediaAttributes() {
        return $this->getElement()->getDataObject()->getMediaAttributes();
    }

    public function getImageTypesJson() {
        return Mage::helper("core")->jsonEncode($this->getImageTypes());
    }
}
