<?php

/**
 * @method int         getEntityId()
 * @method             setEntityId(int $value)
 * @method int         getStoreId()
 * @method             setStoreId(int $value)
 * @method boolean     getEnabled()
 * @method             setEnabled(boolean $value)
 * @method string|null getActiveTo()
 * @method             setActiveTo(string|null $value)
 * @method string|null getActiveFrom()
 * @method             setActiveFrom(string|null $value)
 * @method string      getName()
 * @method             setName(string $value)
 * @method string      getTitle()
 * @method             setTitle(string $value)
 * @method string      getHeading()
 * @method             setHeading(string $value)
 * @method string|null getMetaTitle()
 * @method             setMetaTitle(string|null $value)
 * @method string|null getMetaDescription()
 * @method             setMetaDescription(string|null $value)
 * @method string      getCreatedAt()
 * @method string      getUpdatedAt()
 */
class Crossroads_DynamicCategories_Model_Infoblock extends Crossroads_DynamicCategories_Model_Abstract {
    protected $gallery    = null;
    protected $conditions = null;

    protected function _construct() {
        $this->_init("dynamiccategories/infoblock");
    }

    protected function _beforeSave() {
        parent::_beforeSave();

        $this->setUpdatedAt(gmdate("Y-m-d\\TG:i:s\\Z"));

        $media = [];

        foreach($this->getMediaAttributes() as $attr) {
            $media[$attr["field"]] = $this->getData($attr["field"]);
        }

        $this->setData("media", serialize($media));

        return $this;
    }

    public function getConditions() {
        if( ! $this->conditions) {
            $this->conditions = Mage::getModel("dynamiccategories/infoblock_condition")
                ->getCollection()
                ->filterByInfoblock($this)
                ->joinAttributeNameData()
                ->getItems();
        }

        return $this->conditions;
    }

    public function getGallery() {
        if( ! $this->gallery) {
            $this->gallery = Mage::getModel("dynamiccategories/infoblock_media")
                ->getCollection()
                ->filterByInfoblock($this)
                ->getItems();
        }

        return $this->gallery;
    }

    public function getMediaAttributes() {
        return [
            [ "code" => "large",     "field" => "large",     "label" => "Large"     ],
            [ "code" => "medium",    "field" => "medium",    "label" => "Medium"    ],
            [ "code" => "small",     "field" => "small",     "label" => "Small"     ],
            [ "code" => "logo",      "field" => "logo",      "label" => "Logo"      ],
            [ "code" => "large_2x",  "field" => "large_2x",  "label" => "Large 2x"  ],
            [ "code" => "medium_2x", "field" => "medium_2x", "label" => "Medium 2x" ],
            [ "code" => "small_2x",  "field" => "small_2x",  "label" => "Small 2x"  ],
            [ "code" => "logo_2x",   "field" => "logo_2x",   "label" => "Logo 2x"   ],
        ];
    }

    protected function _afterLoad() {
        if($this->getMedia()) {
            $this->addData(unserialize($this->getMedia()));
        }
    }

    protected function _afterSave() {
        if($this->getData("conditions")) {
            $data       = $this->getData("conditions");
            $conditions = $this->getConditions();

            foreach($conditions as $cond) {
                if( ! array_key_exists($cond->getEntityId(), $data)) {
                    $cond->delete();
                }
            }

            foreach($data as $id => $value) {
                if( ! array_key_exists("attribute_id", $value) || ! array_key_exists("attribute_option_id", $value)) {
                    continue;
                }

                if( ! array_key_exists($id, $conditions)) {
                    $conditions[$id] = Mage::getModel("dynamiccategories/infoblock_condition");
                }

                $conditions[$id]->addData([
                    "infoblock_id"        => $this->getEntityId(),
                    "attribute_id"        => $value["attribute_id"],
                    "attribute_option_id" => $value["attribute_option_id"]
                ])->save();
            }

            $this->unsetData("conditions");

            $this->conditions = null;
        }

        if($this->getData("gallery")) {
            $toMove = [];
            $data   = $this->getData("gallery");

            foreach($data as $img) {
                $model = Mage::getModel("dynamiccategories/infoblock_media");

                if(isset($img["value_id"])) {
                    $model->load($img["value_id"]);
                }
                else {
                    $model->setData([
                        "value" => $this->unTmpImage($img["file"]),
                    ]);
                }

                if($img["removed"]) {
                    $model->delete();
                }
                else {
                    $model->addData([
                        "label"        => $img["label"],
                        "infoblock_id" => $this->getEntityId(),
                    ]);

                    $model->save();
                }
            }
        }

        return parent::_afterSave();
    }

    public function unTmpImage($file) {
        $config = Mage::getSingleton("dynamiccategories/media_config");

        $ioObject = new Varien_Io_File();
        $destDirectory = dirname($config->getMediaPath($file));
        try {
            $ioObject->open(array('path'=>$destDirectory));
        } catch (Exception $e) {
            $ioObject->mkdir($destDirectory, 0777, true);
            $ioObject->open(array('path'=>$destDirectory));
        }

        if (strrpos($file, '.tmp') == strlen($file)-4) {
            $file = substr($file, 0, strlen($file)-4);
        }

        $destFile = $this->_getUniqueFileName($file, $ioObject->dirsep());

        /** @var $storageHelper Mage_Core_Helper_File_Storage_Database */
        $storageHelper = Mage::helper('core/file_storage_database');

        if ($storageHelper->checkDbUsage()) {
            $storageHelper->renameFile($config->getTmpMediaShortUrl($file), $config->getMediaShortUrl($destFile));

            $ioObject->rm($config->getTmpMediaPath($file));
            $ioObject->rm($config->getMediaPath($destFile));
        } else {
            $ioObject->mv($config->getTmpMediaPath($file), $config->getMediaPath($destFile));
        }

        return str_replace($ioObject->dirsep(), '/', $destFile);
    }

    /**
     * Check whether file to move exists. Getting unique name
     *
     * @param <type> $file
     * @param <type> $dirsep
     * @return string
     */
    protected function _getUniqueFileName($file, $dirsep) {
        if(Mage::helper("core/file_storage_database")->checkDbUsage()) {
            return Mage::helper("core/file_storage_database")->getUniqueFilename(
                Mage::getSingleton("catalog/product_media_config")->getBaseMediaUrlAddition(),
                $file
            );
        }

        return dirname($file) . $dirsep . Mage_Core_Model_File_Uploader::getNewFileName(
            Mage::getSingleton("dynamiccategories/media_config")->getMediaPath($file)
        );
    }
}
