<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $installer->getTable("dynamiccategories/infoblock");

if (!$conn->tableColumnExists($table, 'primary_color')) {
    $conn->addColumn($table, "primary_color", [
        "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length"   => 255,
        "nullable" => true,
        "comment"  => "Primary color to be used on the website when browsing the category",
    ]);
}

if (!$conn->tableColumnExists($table, 'featured_products')) {
    $conn->addColumn($table, "featured_products", [
        "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length"   => 255,
        "nullable" => true,
        "comment"  => "Command-separated product IDs",
    ]);
}

if (!$conn->tableColumnExists($table, 'featured_products_title')) {
    $conn->addColumn($table, "featured_products_title", [
        "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length"   => 255,
        "nullable" => true,
        "comment"  => "Title for featured products excerpt",
    ]);
}

if (!$conn->tableColumnExists($table, 'featured_products_url')) {
    $conn->addColumn($table, "featured_products_url", [
        "type"     => Varien_Db_Ddl_Table::TYPE_TEXT,
        "length"   => 255,
        "nullable" => true,
        "comment"  => "Show \"Visa alla\" on product excerpt when not NULL",
    ]);
}

$installer->endSetup();
