<?php

declare(strict_types=1);

use MageQL\Context;
use MageQL\Registry;
use MageQL\Type\AbstractBuilder;

class Crossroads_DynamicCategories_Model_Schema extends MageQL_Core_Model_Schema_Abstract {
    public function getTypeBuilder(string $typeName, Registry $registry): ?AbstractBuilder {
        switch($typeName) {
            case "DynamicCategoryInfoImage":
                return $this->object("Dynamic category info images")->setResolveField("MageQL\\defaultVarienObjectResolver");
            case "DynamicCategoryInfoBlock":
                return $this->object("Dynamic category info block")->setResolveField("MageQL\\defaultVarienObjectResolver");
            default:
                return null;
        }
    }

    public function getTypeFields(string $typeName, Registry $registry): array {
        switch($typeName) {
            case "DynamicCategoryInfoImage":
                return [
                    "label" =>  $this->field("String!","Title of info block"),
                    "image" => $this->field("ImageData!", "Gallery item image data")
                ];
            case "DynamicCategoryInfoBlock":
                return [
                    "title" =>  $this->field("String!","Title of info block"),
                    "heading" => $this->field("String!","Heading of info block"),
                    "metaTitle" => $this->field("String","Meta title of info block"),
                    "metaDescription" => $this->field("String","Meta description of info block"),
                    "gallery" => $this->field("[DynamicCategoryInfoImage!]!","Title of info block")
                ];
            case "FilterableProductList":
            case "SortableProductList":
                return [
                    'infoBlock' => $this->field('DynamicCategoryInfoBlock', "Info-block for the dynamic category best matching the applied filters, if any.")
                        ->setResolver(function(MageQL_Catalog_Model_Product_FilterableCollectionInterface $productList, array $args, Context $ctx): ?Crossroads_DynamicCategories_Model_Infoblock {
                            $filters = [];
                            $storeId = $ctx->getStore()->getStoreId();

                            foreach ($productList->getAppliedFilters() as $f) {
                                if (array_key_exists('value',$f)) {
                                    $filters[$f['code']] = $f['value'];
                                }
                            }

                            if(count($filters) === 0) {
                                return null;
                            }

                            $blocks = Mage::getResourceModel("dynamiccategories/infoblock_collection");
                            $blocks->filterByStore($storeId);
                            $blocks->filterByAttributes($filters, $storeId);
                            $blocks->filterActive();
                            $blocks->orderByPriority();

                            $block = $blocks->getFirstItem();

                            if(!$block->getId()) {
                                return null;
                            }

                            return $block;
                        })

                ];
            default:
                return [];
        }
    }
}