<?php

class Crossroads_DynamicCategories_Helper_Data extends Mage_Core_Helper_Abstract {
    public function getEnabledOptions() {
        return [
            1 => $this->__("Yes"),
            0 => $this->__("No"),
        ];
    }

    public function apiBrandItemResponse($event) {
        $brand   = $event->getBrand();
        $resp    = $event->getResponse();
        $storeId = Mage::app()->getStore()->getStoreId();

        $blocks = Mage::getModel("dynamiccategories/infoblock")
            ->getCollection()
            ->filterByStore($storeId)
            ->filterByAttributes([
                "manufacturer" => $brand,
            ], $storeId)
            ->filterActive()
            ->orderByPriority();

        $block = $blocks->getFirstItem();

        if($block->getEntityId()) {
            $resp->setData("infoBlock", $this->prepareBlock($block));
        }
    }

    public function elasticsearchFacetedResponse($event) {
        $params  = $event->getParams();
        $resp    = $event->getResponse();
        $storeId = Mage::app()->getStore()->getStoreId();

        if(empty($params)) {
            return;
        }

        $blocks = Mage::getModel("dynamiccategories/infoblock")
            ->getCollection()
            ->filterByStore($storeId)
            ->filterByAttributes($params, $storeId)
            ->filterActive()
            ->orderByPriority();

        $block = $blocks->getFirstItem();

        $featuredIds = !empty($block->getFeaturedProducts()) ?
            array_map("trim", explode(",", $block->getFeaturedProducts())) :
            null;
        $featuredProducts = [];

        if ($featuredIds) {
            $featuredProducts = Mage::getModel("catalog/product")
                ->getCollection()
                ->addAttributeToSelect("*")
                ->addPriceData()
                ->addAttributeToFilter("entity_id", ["in" => $featuredIds]);
        }

        if($block->getEntityId()) {
            $resp->setData("infoBlock", $this->prepareBlock($block, $featuredProducts));
        }
    }

    public function prepareBlock($block, $featuredProducts) {
        $featuredProductsData = null;

        if (count($featuredProducts) > 0) {
            $store = Mage::app()->getStore();
            $factory = Mage::getModel("API/factory");
            $prodSer = $factory->createProductListSerializer($store);

            $featuredProductsData = [
                "title" => $block->getFeaturedProductsTitle(),
                "url" => $block->getFeaturedProductsUrl(),
                "items" => $prodSer->mapCollection($featuredProducts),
            ];
        }

        return [
            "id"               => (int)$block->getEntityId(),
            "name"             => $block->getHeading() ?: null,
            "title"            => $block->getTitle() ?: null,
            "description"      => $block->getDescription(),
            "metaDescription"  => $block->getMetaDescription(),
            "metaTitle"        => $block->getMetaTitle(),
            "primaryColor"     => $block->getPrimaryColor(),
            "instagramURL"     => $block->getInstagramUrl(),
            "bannerURL"        => $block->getBannerUrl(),
            "images"           => $this->prepareBlockImages($block),
            "featuredProducts" => $featuredProductsData,
        ];
    }

    public function prepareBlockImages($block) {
        $images = [];

        foreach($block->getMediaAttributes() as $attr) {
            $img = $block->getData($attr["field"]);

            if($img && $img !== "no_selection") {
                $images[$attr["field"]] = [
                    "url"     => Mage::getSingleton("dynamiccategories/media_config")->getBaseMediaUrl() . $img,
                ];
            }
        }

        return empty($images) ? new stdClass : $images;
    }
}
