<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tabs extends Mage_Adminhtml_Block_Widget_Tabs {
    public function __construct() {
        parent::__construct();

        $this->setDestElementId("edit_form");
    }

    protected function _prepareLayout() {
        $form             = $this->getLayout()->createBlock("dynamiccategories/adminhtml_infoblock_edit_tab_form");
        $conditions       = $this->getLayout()->createBlock("dynamiccategories/adminhtml_infoblock_edit_tab_conditions");
        $featuredProducts = $this->getLayout()->createBlock("dynamiccategories/adminhtml_infoblock_edit_tab_featuredProducts");
        $gallery          = $this->getLayout()->createBlock("dynamiccategories/adminhtml_infoblock_edit_tab_gallery");

        // $gallery->setElement($this);

        $this->addTab("infoblock_general", [
            "label"   => Mage::helper("dynamiccategories")->__("General"),
            "content" => $form->toHtml(),
        ]);
        $this->addTab("infoblock_conditions", [
            "label"   => Mage::helper("dynamiccategories")->__("Conditions"),
            "content" => $conditions->toHtml(),
        ]);
        $this->addTab("infoblock_featured_products", [
            "label"   => Mage::helper("dynamiccategories")->__("Featured products"),
            "content" => $featuredProducts->toHtml(),
        ]);
        $this->addTab("infoblock_media_gallery", [
            "label"   => Mage::helper("dynamiccategories")->__("Media Gallery"),
            "content" => $gallery->toHtml(),
        ]);
    }

    public function getLabel() {
        return "";
    }

    public function getDataObject() {
        return Mage::registry("current_infoblock");
    }
}
