<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tab_Form extends Mage_Adminhtml_Block_Catalog_Form {
    protected function _prepareForm() {
        $form = new Varien_Data_Form();

        $this->setForm($form);
        $this->setDataObject($this->_getInfoblock());
        $form->setDataObject($this->_getInfoblock());

        $fieldset           = $form->addFieldset( "general", [ "legend" => $this->__("Details") ]);
        $infoblockSingleton = Mage::getSingleton("dynamiccategories/infoblock");

        $this->_setFieldset([
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Name"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "name",
                "is_required"    => true,
                "note"           => "Internal name.",
                "scope"          => "global",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Enabled"),
                    "input_type" => "select",
                ]),
                "attribute_code" => "enabled",
                "is_required"    => true,
                "source"         => Mage::getSingleton("eav/entity_attribute_source_boolean"),
                "scope"          => "store",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Priority"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "priority",
                "note"           => "If multiple blocks match and have the same number of matching conditions, the one with the highest priority wins.",
                "is_required"    => false,
                "scope"          => "global",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Active from"),
                    "input_type" => "datetime",
                ]),
                "attribute_code" => "active_from",
                "is_required"    => false,
                "scope"          => "global",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Active to"),
                    "input_type" => "datetime",
                ]),
                "attribute_code" => "active_to",
                "is_required"    => false,
                "scope"          => "global",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Primary color (example: #000000)"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "primary_color",
                "is_required"    => false,
                "scope"          => "global",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Instagram URL"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "instagram_url",
                "is_required"    => false,
                "scope"          => "global",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Banner URL"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "banner_url",
                "is_required"    => false,
                "scope"          => "global",
            ]),
        ], $fieldset);

        $contentFieldset = $form->addFieldset("infoblock_content", [ "legend" => $this->__("Content") ]);

        $this->_setFieldset([
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Title"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "title",
                "scope"          => "store",
                "note"           => "Title information for the page containing the info block."
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Heading"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "heading",
                "scope"          => "store",
                "note"           => "Text shown as a heading for the info block.",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Meta Title"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "meta_title",
                "scope"          => "store",
                "note"           => "Maximum length 160 characters.",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Meta Description"),
                    "input_type" => "text",
                ]),
                "attribute_code" => "meta_description",
                "scope"          => "store",
                "note"           => "Maximum length 160 characters.",
            ]),
            Mage::getModel("dynamiccategories/attribute", [
                "frontend" => new Varien_Object([
                    "label"      => $this->__("Block description"),
                    "title"      => $this->__("Block description"),
                    "input_type" => "editor",
                ]),
                "attribute_code" => "description",
                "scope"          => "store",
            ]),
        ], $contentFieldset);

        $form->addValues($this->getDataObject()->getData());
        $form->setFieldNameSuffix('infoblockData');
    }

    protected function _addFieldsToFieldset(Varien_Data_Form_Element_Fieldset $fieldset, $fields) {
        $requestData = new Varien_Object($this->getRequest()->getPost("infoblockData"));

        foreach($fields as $name => $data) {
            if($requestValue = $requestData->getData($name)) {
                $data["value"] = $requestValue;
            }

            $data["name"]  = "infoblockData[$name]";
            $data["title"] = $data["label"];

            if(!array_key_exists("value", $data)) {
                $data["value"] = $this->_getInfoblock()->getData($name);
            }

            $fieldset->addField($name, $data["input"], $data);
        }

        return $this;
    }

    protected function _getInfoblock() {
        if( ! $this->hasData("infoblock")) {
            // Set in controller
            $infoblock = Mage::registry("current_infoblock");

            if (!$infoblock instanceof Crossroads_DynamicCategories_Model_Infoblock) {
                $infoblock = Mage::getModel("dynamiccategories/infoblock");
            }

            $this->setData("infoblock", $infoblock);
        }

        return $this->getData("infoblock");
    }
    protected function _getAdditionalElementTypes() {
        return [
            "editor" => Mage::getConfig()->getBlockClassName("dynamiccategories/adminhtml_helper_form_editor"),
        ];
    }
}
