<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tab_FeaturedProducts extends Mage_Adminhtml_Block_Catalog_Form {
    protected function _prepareForm() {
        $form = new Varien_Data_Form();

        $requestData = $this->getRequest()->getPost("infoblockData");

        $form->setDataObject(Mage::registry("current_infoblock"));
        $this->setForm($form);

        $fieldset = $form->addFieldset("infoblock_products", [ "legend" => $this->__("Featured products") ]);


        $fieldset->addField("featured_products", "text", [
            "title" => Mage::helper("dynamiccategories")->__("Featured products (comma-separated IDs)"),
            "label" => Mage::helper("dynamiccategories")->__("Featured products (comma-separated IDs)"),
            "value" => ($requestData && array_key_exists("featured_products", $requestData) ? $requestData["featured_products"] : Mage::registry("current_infoblock")->getFeaturedProducts()) ?: "",
            "name"  => "infoblockData[featured_products]",
        ]);

        $fieldset->addField("featured_products_url", "text", [
            "title" => Mage::helper("dynamiccategories")->__("Featured products URL (displays link on product excerpt if not empty"),
            "label" => Mage::helper("dynamiccategories")->__("Featured products URL (displays link on product excerpt if not empty"),
            "value" => ($requestData && array_key_exists("featured_products_url", $requestData) ? $requestData["featured_products_url"] : Mage::registry("current_infoblock")->getFeaturedProductsUrl()) ?: "",
            "name"  => "infoblockData[featured_products_url]",
        ]);

        $fieldset->addField("featured_products_title", "text", [
            "title" => Mage::helper("dynamiccategories")->__("Featured products title on excerpt"),
            "label" => Mage::helper("dynamiccategories")->__("Featured products title on excerpt"),
            "value" => ($requestData && array_key_exists("featured_products_title", $requestData) ? $requestData["featured_products_title"] : Mage::registry("current_infoblock")->getFeaturedProductsTitle()) ?: "",
            "name"  => "infoblockData[featured_products_title]",
        ]);

        return $this;
    }
}
