<?php

class Crossroads_DynamicCategories_Model_Resource_Infoblock_Condition_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract {
    protected function _construct() {
        parent::_construct();

        $this->_init("dynamiccategories/infoblock_condition");
    }

    public function filterByInfoblock($infoblock) {
        $this->addFieldToFilter("infoblock_id", $infoblock->getEntityId());

        return $this;
    }

    public function joinAttributeNameData() {
        $conn   = $this->getConnection();
        $select = $this->getSelect();

        $select->joinLeft(
            ["eao" => $this->getTable("eav/attribute_option")],
            "main_table.attribute_id = eao.attribute_id AND eao.option_id = main_table.attribute_option_id",
            []
        )
        ->joinLeft(
            ["eaov" => $this->getTable("eav/attribute_option_value")],
            "eao.option_id = eaov.option_id AND eaov.store_id = 0",
            ["value"]
        );

        return $this;
    }
}
