<?php

class Crossroads_DynamicCategories_Model_Abstract extends Mage_Core_Model_Abstract {
    /**
     * List of overridden attribute values from general scope.
     */
    protected $_defaultAttributeValues = null;
    /**
     * List of keys present in the store.
     */
    protected $_storeAttributeKeys = null;

    protected function _getDefaultAttributeValues() {
        if($this->_defaultAttributeValues === null) {
            $this->_defaultAttributeValues = $this->getResource()->loadDefaultAttributeValues($this);
        }

        return $this->_defaultAttributeValues;
    }

    protected function _getStoreAttributeKeys() {
        if($this->_storeAttributeKeys === null) {
            $this->_storeAttributeKeys = array_keys(array_filter($this->getResource()->loadStoreAttributeValues($this), function($v) {
                return $v !== null;
            }));
        }

        return $this->_storeAttributeKeys;
    }

    /**
     * Retrieve default value for attribute code
     *
     * @param   string $attributeCode
     * @return  array|boolean
     */
    public function getAttributeDefaultValue($key) {
        $values = $this->_getDefaultAttributeValues();

        return array_key_exists($key, $values) ? $values[$key] : false;
    }

    /**
     * Check if object attribute has value in current store
     *
     * @param   string $attributeCode
     * @return  bool
     */
    public function getExistsStoreValueFlag($key) {
        return in_array($key, $this->_getStoreAttributeKeys());
    }
}
