<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("dynamiccategories/infoblock_store"))
    ->addColumn("infoblock_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
        "primary"  => true,
    ], "Link to infoblock entity id")
    ->addColumn("store_id", Varien_Db_Ddl_Table::TYPE_SMALLINT, null, [
        "unsigned" => true,
        "nullable" => false,
        "primary"  => true,
    ], "Store ID")
    ->addColumn("enabled", Varien_Db_Ddl_Table::TYPE_BOOLEAN, null, [
        "nullable" => true,
    ], "Enabled override")
    ->addColumn("title", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => true,
    ], "Title override")
    ->addColumn("title", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => true,
    ], "Title override")
    ->addColumn("heading", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => true,
    ], "Heading override")
    ->addColumn("meta_title", Varien_Db_Ddl_Table::TYPE_TEXT, 160, [
        "nullable" => true,
    ], "Meta title override")
    ->addColumn("meta_description", Varien_Db_Ddl_Table::TYPE_TEXT, 160, [
        "nullable" => true,
    ], "Meta description override")
    ->addColumn("description", Varien_Db_Ddl_Table::TYPE_TEXT, null, [
        "nullable" => true
    ], "Description override")
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock_store", "infoblock_id",
            "dynamiccategories/infoblock", "entity_id"
        ),
        "infoblock_id", $installer->getTable("dynamiccategories/infoblock"), "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock_store", "store_id",
            "core/store", "store_id"
        ),
        "store_id", $installer->getTable("core/store"), "store_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
