<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Grid extends Mage_Adminhtml_Block_Widget_Grid {
    protected function _prepareCollection() {
        $this->setCollection(Mage::getResourceModel("dynamiccategories/infoblock_collection"));

        return parent::_prepareCollection();
    }

    public function getRowUrl($row) {
        return $this->getUrl(
            "adminhtml/dynamiccategories_infoblock/edit",
            [ "id" => $row->getId() ]
        );
    }

    protected function _prepareColumns() {
        $this->addColumn("entity_id", [
            "header" => $this->_getHelper()->__("ID"),
            "type"   => "number",
            "index"  => "entity_id",
        ]);

        $this->addColumn("name", [
            "header" => $this->_getHelper()->__("Name"),
            "type"   => "text",
            "index"  => "name",
        ]);

        $this->addColumn("title", [
            "header" => $this->_getHelper()->__("Title"),
            "type"   => "text",
            "index"  => "title",
        ]);

        $this->addColumn("enabled", [
            "header"  => $this->_getHelper()->__("Enabled"),
            "type"    => "options",
            "index"   => "enabled",
            "options" => $this->_getHelper()->getEnabledOptions(),
        ]);

        $this->addColumn("active_from", [
            "header" => $this->_getHelper()->__("Active From"),
            "type"   => "datetime",
            "index"  => "active_from",
        ]);

        $this->addColumn("active_to", [
            "header" => $this->_getHelper()->__("Active To"),
            "type"   => "datetime",
            "index"  => "active_to",
        ]);

        $this->addColumn("priority", [
            "header" => $this->_getHelper()->__("Priority"),
            "type"   => "number",
            "index"  => "priority",
        ]);

        $this->addColumn("created_at", [
            "header" => $this->_getHelper()->__("Created"),
            "type"   => "datetime",
            "index"  => "created_at",
        ]);

        $this->addColumn("updated_at", [
            "header" => $this->_getHelper()->__("Updated"),
            "type"   => "datetime",
            "index"  => "updated_at",
        ]);

        $this->addColumn("action", [
            "header"  => $this->_getHelper()->__("Action"),
            "width"   => "50px",
            "type"    => "action",
            "actions" => [
                [
                    "caption" => $this->_getHelper()->__("Edit"),
                    "url"     => [ "base" => "adminhtml/dynamiccategories_infoblock/edit" ],
                    "field"   => "id"
                ],
            ],
            "filter" => false,
            "sortable" => false,
            "index" => "entity_id",
        ]);

        return parent::_prepareColumns();
    }

    protected function _getHelper() {
        return Mage::helper("dynamiccategories");
    }
}
