<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tab_Conditions_Element extends Varien_Data_Form_Element_Abstract {
    public function getElementHtml() {
        $attributes = Mage::getResourceModel("dynamiccategories/infoblock")->getProductSelectAttributes();
        $values     = $this->getValue();
        $firstAttr  = reset($attributes);
        $lastValue  = end($values);
        $lastId     = $lastValue ? $lastValue->getEntityId() + 1 : 1;

        ob_start();
?>
<table>
    <thead>
        <tr>
            <th>
                <?php echo Mage::helper("dynamiccategories")->__("Filter Attribut"); ?>
            </th>
            <th>
                <?php echo Mage::helper("dynamiccategories")->__("Värde"); ?>
            </th>
            <th>
                <button class="scalable add" type="button" id="<?php echo $this->getHtmlId(); ?>__add_btn">
                    <span><span><span><?php echo Mage::helper("dynamiccategories")->__("Add") ?></span></span></span>
                </button>
            </th>
        </tr>
    </thead>
    <tbody id="<?php echo $this->getHtmlId(); ?>">
        <?php foreach($this->getValue() as $condition): ?>
        <tr id="<?php echo $this->getHtmlId()."_".$condition->getEntityId() ?>" data-id="<?php echo $condition->getEntityId(); ?>">
            <td>
                <select name="<?php echo $this->getName()."[".$condition->getEntityId()."][attribute_id]"; ?>" data-select-type="attribute">
                    <?php foreach($attributes as $attr): ?>
                    <option <?php echo $condition->getAttributeId() == $attr["attribute_id"] ? " selected " : "" ?> value="<?php echo $attr["attribute_id"] ?>"><?php echo $attr["frontend_label"] ?></option>
                    <?php endforeach; ?>
                </select>
            </td>

            <td>
                <?php if(array_key_exists($condition->getAttributeId(), $attributes)): ?>
                    <select name="<?php echo $this->getName()."[".$condition->getEntityId()."][attribute_option_id]"; ?>">
                        <?php foreach($attributes[$condition->getAttributeId()]["options"] as $opt): ?>
                        <option <?php echo $condition->getAttributeOptionId() == $opt["id"] ? " selected " : "" ?> value="<?php echo $opt["id"] ?>"><?php echo $opt["value"] ?></option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>
            </td>
            <td>
                <button onclick="$('<?php echo $this->getHtmlId()."_".$condition->getEntityId() ?>').remove()" class="scalable delete" type="button">
                  <span><span><span><?php echo Mage::helper('adminhtml')->__('Delete') ?></span></span></span>
                </button>
            </td>
        </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script type="text/javascript">
(function() {
    var gridId   = <?php echo json_encode($this->getHtmlId()) ?>;
    var gridBody = $(gridId);
    var options  = <?php echo json_encode(array_map(function($attr) { return array_values($attr["options"]); }, $attributes)); ?>;
    var lastId   = <?php echo json_encode($lastId); ?>;

    function template(prefix, id) {
        return "<tr id=\"" + prefix + id + "\" data-id=\"" + id + "\">" +
            "<td>" +
                "<select name=\"<?php echo $this->getName() ?>[" + id + "][attribute_id]\" data-select-type=\"attribute\">" +
                    <?php foreach($attributes as $attr): ?>
                    "<option value=\"<?php echo $attr["attribute_id"] ?>\"><?php echo $attr["frontend_label"] ?></option>" +
                    <?php endforeach; ?>
                "</select>" +
            "</td>" +

            "<td>" +
                "<select name=\"<?php echo $this->getName().""; ?>[" + id + "][attribute_option_id]\">" +
                    <?php foreach($firstAttr["options"] as $opt): ?>
                    "<option value=\"<?php echo $opt["id"] ?>\"><?php echo $opt["value"] ?></option>" +
                    <?php endforeach; ?>
                "</select>" +
            "</td>" +
            "<td>" +
                "<button onclick=\"$('" + prefix + id + "').remove()\" class=\"scalable delete\" type=\"button\">" +
                  "<span><span><span><?php echo Mage::helper('adminhtml')->__('Delete') ?></span></span></span>" +
                "</button>" +
            "</td>" +
        "</tr>";
    }

    function addRow() {
        lastId++;

        gridBody.insert(template(gridId + "__js__", lastId));
    }

    /**
     * Listen to the <tbody> for all change events from <select> and propagate the actual data to
     * the <input>s.
     */
    function onChange(event, rowEl) {
        if(event.target.tagName !== "SELECT" || event.target.getAttribute("data-select-type") !== "attribute") {
            return;
        }

        var id   = rowEl.getAttribute("data-id");
        var td   = rowEl.select("td")[1]
        var opts = options[event.target.value];

        td.innerHTML = "<select name=\"<?php echo $this->getName(); ?>[" + id + "][attribute_option_id]\">" +
            opts.map(function(opt) {
                return "<option value=" + opt.id + ">" + opt.value + "</option>";
            }).join("") +
        "</select>";
    }

    Event.observe(gridId + "__add_btn", 'click', addRow);
    gridBody.on("change", "tr", onChange);
})();
</script>
<?php
        return ob_get_clean();
    }
}
