<?php

class Crossroads_DynamicCategories_Model_Resource_Infoblock_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract {
    protected $_storeId = null;

    protected function _construct() {
        parent::_construct();

        $this->_init("dynamiccategories/infoblock");
    }

    public function filterByAttributes($data, $storeId = 0) {
        $db     = $this->getConnection();
        $params = [];
        $select = $this->getSelect()
            ->join(["cond" => $this->getTable("dynamiccategories/infoblock_condition")], "main_table.entity_id = cond.infoblock_id", [])
            ->join(["ea" => $this->getTable("eav/attribute")], "cond.attribute_id = ea.attribute_id", [])
            ->join(["eaov" => $this->getTable("eav/attribute_option_value")], "cond.attribute_option_id = eaov.option_id", [])
            ->where("eaov.store_id IN (0, ?)", $storeId);

        foreach($data as $k => $v) {
            foreach(is_array($v) ? $v : [$v] as $val) {
                $params[] = sprintf("(ea.attribute_code = %s AND eaov.value = %s)", $db->quote($k), $db->quote($val));
            }
        }

        $countCond = sprintf("(SELECT COUNT(1) FROM %s cond_count WHERE cond_count.infoblock_id = main_table.entity_id)", $this->getTable("dynamiccategories/infoblock_condition"));

        $select->where(implode(" OR ", $params))
            ->group("main_table.entity_id")
            ->having("COUNT(cond.entity_id) >= ".$countCond)
            ->order(new Zend_Db_Expr($countCond." DESC"));

        return $this;
    }

    public function filterActive() {
        $this->getSelect()
            ->where("main_table.active_from IS NULL OR main_table.active_from <= NOW()")
            ->where("main_table.active_to   IS NULL OR main_table.active_to   >= NOW()");

        if( ! $this->_storeId) {
            $this->getSelect()->where("main_table.enabled = 1");
        }
        else {
            $this->getSelect()->where("main_table.enabled AND (store_table.enabled IS NULL OR store_table.enabled = 1)");
        }

        return $this;
    }

    public function filterByStore($storeId) {
        $this->_storeId = $storeId;

        $select  = $this->getSelect();
        $res     = $this->getResource();
        $conn    = $this->getConnection();
        $columns = [];
        $cols    = $conn->describeTable($res->getStoreTable());
        $skip    = [$res->getStoreEntityFk(), $res->getStoreEntityPk()];

        foreach(array_keys($cols) as $key) {
            if( ! in_array($key, $skip)) {
                $columns[$key] = new Zend_Db_Expr(sprintf(
                    "COALESCE(%s, %s)",
                    $conn->quoteIdentifier("store_table.".$key),
                    $conn->quoteIdentifier("main_table.".$key)
                ));
            }
        }

        $columns["store_id"] = new Zend_Db_Expr($conn->quoteInto("?", $storeId));

        $select->joinLeft([ "store_table" => $res->getStoreTable() ],
            $conn->quoteInto($conn->quoteIdentifier("store_table.".$res->getStoreEntityFk())." = ?", $storeId).
            " AND ".
            $conn->quoteIdentifier("main_table.".$res->getIdFieldName())." = ".$conn->quoteIdentifier("store_table.".$res->getStoreEntityPk()), [])
            ->columns($columns);

        return $this;
    }

    public function orderByPriority() {
        $this->getSelect()
            ->order(new Zend_Db_Expr("main_table.priority = 0, main_table.priority DESC"));

        return $this;
    }

    protected function _afterLoad() {
        foreach($this->_items as $item) {
            if($item->getMedia()) {
                $item->addData(unserialize($item->getMedia()));
            }
        }

        return parent::_afterLoad();
    }
}
