<?php

class Crossroads_DynamicCategories_Adminhtml_Dynamiccategories_InfoblockController extends Mage_Adminhtml_Controller_Action {
    public function indexAction() {
        $this->loadLayout();

        $content = $this->getLayout()->createBlock("dynamiccategories_adminhtml/infoblock");

        $this->_addContent($content);

        $this->renderLayout();
    }

    public function editAction() {
        $infoblock = Mage::getModel("dynamiccategories/infoblock");

        if($id = $this->getRequest()->getParam("id", false)) {
            $infoblock->load($id);

            if( ! $infoblock->getId()) {
                $this->_getSession()->addError($this->__("This infoblock no longer exists."));

                return $this->_redirect("adminhtml/dynamiccategories_infoblock");
            }
        }

        if($postData = $this->getRequest()->getPost("infoblockData")) {
            try {
                $infoblock->addData($postData);

                if(is_string($infoblock->getData("gallery", "images"))) {
                    // $infoblock->addData(json_decode($infoblock->getData("gallery", "values"), true));
                    $infoblock->setData("gallery", json_decode($infoblock->getData("gallery", "images"), true));
                }

                $infoblock->save();

                $this->_getSession()->addSuccess($this->__("The infoblock has been saved."));

                // redirect to remove $_POST data from the request
                return $this->_redirect("adminhtml/dynamiccategories_infoblock/edit", ["id" => $infoblock->getId()]);
            }
            catch(Exception $e) {
                Mage::logException($e);
                $this->_getSession()->addError($e->getMessage());
            }
        }

        Mage::register("current_infoblock", $infoblock);

        $infoblockEditBlock = $this->getLayout()->createBlock("dynamiccategories_adminhtml/infoblock_edit");

        $this->loadLayout()->_addContent($infoblockEditBlock)->renderLayout();
    }

    public function deleteAction()
    {
        $infoblock = Mage::getModel("dynamiccategories/infoblock");

        if($id = $this->getRequest()->getParam("id", false)) {
            $infoblock->load($id);
        }

        if( ! $infoblock->getId()) {
            $this->_getSession()->addError($this->__("This infoblock no longer exists."));

            return $this->_redirect("adminhtml/dynamiccategories_infoblock/index");
        }

        try {
            $infoblock->delete();

            $this->_getSession()->addSuccess($this->__("The infoblock has been deleted."));
        }
        catch(Exception $e) {
            Mage::logException($e);

            $this->_getSession()->addError($e->getMessage());
        }

        return $this->_redirect("adminhtml/dynamiccategories_infoblock/index");
    }
}
