<?php

class Crossroads_DynamicCategories_Helper_Data extends Mage_Core_Helper_Abstract {
    public function getEnabledOptions() {
        return [
            1 => $this->__("Yes"),
            0 => $this->__("No"),
        ];
    }

    public function apiBrandItemResponse($event) {
        $brand   = $event->getBrand();
        $resp    = $event->getResponse();
        $storeId = Mage::app()->getStore()->getStoreId();

        $blocks = Mage::getModel("dynamiccategories/infoblock")
            ->getCollection()
            ->filterActive()
            ->filterByStore($storeId)
            ->filterByAttributes([
                "manufacturer" => $brand,
            ], $storeId)
            ->orderByPriority();

        $block = $blocks->getFirstItem();

        if($block->getEntityId()) {
            $resp->setData("infoBlock", $this->prepareBlock($block));
        }
    }

    public function elasticsearchFacetedResponse($event) {
        $params  = $event->getParams();
        $resp    = $event->getResponse();
        $storeId = Mage::app()->getStore()->getStoreId();

        if(empty($params)) {
            return;
        }

        $blocks = Mage::getModel("dynamiccategories/infoblock")
            ->getCollection()
            ->filterActive()
            ->filterByStore($storeId)
            ->filterByAttributes($params, $storeId)
            ->orderByPriority();

        $block = $blocks->getFirstItem();

        if($block->getEntityId()) {
            $resp->setData("infoBlock", $this->prepareBlock($block));
        }
    }

    public function prepareBlock($block) {
        return [
            "id"              => (int)$block->getEntityId(),
            "name"            => $block->getHeading(),
            "title"           => $block->getTitle(),
            "description"     => $block->getDescription(),
            "metaDescription" => $block->getMetaDescription(),
            "metaTitle"       => $block->getMetaTitle(),
            "images"          => $this->prepareBlockImages($block),
        ];
    }

    public function prepareBlockImages($block) {
        $images = [];

        foreach($block->getMediaAttributes() as $attr) {
            $img = $block->getData($attr["field"]);

            if($img && $img !== "no_selection") {
                $images[$attr["field"]] = [
                    "url"     => Mage::getSingleton("dynamiccategories/media_config")->getBaseMediaUrl() . $img,
                ];
            }
        }

        return empty($images) ? new stdClass : $images;
    }
}
