<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tab_Gallery_Element extends Varien_Data_Form_Element_Abstract {
    public function getElementHtml() {
        return Mage::getSingleton('core/layout')
            ->createBlock("dynamiccategories/adminhtml_infoblock_edit_tab_gallery_widget")
            ->setId($this->getHtmlId() . '_content')
            ->setElement($this)
            ->toHtml();
    }

    public function getLabel() {
        return '';
    }

    /**
     * Check "Use default" checkbox display availability
     *
     * @param Mage_Eav_Model_Entity_Attribute $attribute
     * @return bool
     */
    public function canDisplayUseDefault($attribute) {
        return false;
    }

    /**
     * Check default value usage fact
     *
     * @param Mage_Eav_Model_Entity_Attribute $attribute
     * @return bool
     */
    public function usedDefault($attribute)
    {
        return false;
    }

    public function getScopeLabel($attribute) {
        return "";
    }

    /**
     * Retrieve data object related with form
     */
    public function getDataObject()
    {
        return $this->getForm()->getDataObject();
    }

    /**
     * Retrieve attribute field name
     *
     *
     * @param Mage_Eav_Model_Entity_Attribute $attribute
     * @return string
     */
    public function getAttributeFieldName($attribute)
    {
        $name = $attribute->getAttributeCode();
        if ($suffix = $this->getForm()->getFieldNameSuffix()) {
            $name = $this->getForm()->addSuffixToName($name, $suffix);
        }
        return $name;
    }

    public function toHtml()
    {
        return '<tr><td class="value" colspan="3">' . $this->getElementHtml() . '</td></tr>';
    }

    /**
     * Default sore ID getter
     *
     * @return integer
     */
    protected function _getDefaultStoreId()
    {
        return Mage_Catalog_Model_Abstract::DEFAULT_STORE_ID;
    }
}
