<?php

$installer = $this;

$installer->startSetup();

$conn = $installer->getConnection();

$table = $conn->newTable($installer->getTable("dynamiccategories/infoblock_media"))
    ->addColumn("value_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "identity" => true,
        "auto_increment" => true,
        "unsigned" => true,
        "nullable" => false,
        "primary" => true,
    ], "Value id")
    ->addColumn("infoblock_id", Varien_Db_Ddl_Table::TYPE_INTEGER, null, [
        "unsigned" => true,
        "nullable" => false,
    ])
    ->addColumn("label", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
        "default"  => "",
    ])
    ->addColumn("value", Varien_Db_Ddl_Table::TYPE_TEXT, 255, [
        "nullable" => false,
    ])
    ->addForeignKey(
        $installer->getFkName(
            "dynamiccategories/infoblock_media",
            "infoblock_id",
            "dynamiccategories/infoblock",
            "entity_id"
        ),
        "infoblock_id", $installer->getTable("dynamiccategories/infoblock"), "entity_id",
        Varien_Db_Ddl_Table::ACTION_CASCADE, Varien_Db_Ddl_Table::ACTION_CASCADE)
    ->setOption("type", "InnoDB")
    ->setOption("charset", "utf8");

$conn->createTable($table);

$installer->endSetup();
