<?php

class Crossroads_DynamicCategories_Model_Resource_Infoblock_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract {
    protected function _construct() {
        parent::_construct();

        $this->_init("dynamiccategories/infoblock");
    }

    public function filterByAttributes($data, $storeId = 0) {
        $select = $this->getSelect()
            ->join(["cond" => $this->getTable("dynamiccategories/infoblock_condition")], "main_table.entity_id = cond.infoblock_id", [])
            ->join(["ea" => $this->getTable("eav/attribute")], "cond.attribute_id = ea.attribute_id", [])
            ->join(["eaov" => $this->getTable("eav/attribute_option_value")], "cond.attribute_option_id = eaov.option_id", [])
            ->where("eaov.store_id IN (0, ?)", $storeId);

        foreach($data as $k => $v) {
            $select->where("ea.attribute_code = ?", $k);
            $select->where("eaov.value IN (?)", is_array($v) ? $v : [$v]);
        }

        return $this;
    }

    public function filterActive() {
        $this->getSelect()
            ->where("main_table.enabled = 1")
            ->where("main_table.active_from IS NULL OR main_table.active_from <= NOW()")
            ->where("main_table.active_to   IS NULL OR main_table.active_to   >= NOW()");

        return $this;
    }

    public function filterByStore($storeId) {
        $this->getSelect()
            ->where("main_table.store_id IN (0, ?)", $storeId);

        return $this;
    }

    public function orderByPriority() {
        $this->getSelect()
            ->order(new Zend_Db_Expr("main_table.priority = 0, main_table.priority DESC"));

        return $this;
    }

    protected function _afterLoad() {
        foreach($this->_items as $item) {
            if($item->getMedia()) {
                $item->addData(unserialize($item->getMedia()));
            }
        }

        return parent::_afterLoad();
    }
}
