<?php

class Crossroads_DynamicCategories_Model_Resource_Infoblock extends Mage_Core_Model_Resource_Db_Abstract {
    protected function _construct() {
        $this->_init("dynamiccategories/infoblock", "entity_id");
    }

    public function getProductSelectAttributes() {
        $sql = $this->getReadConnection();

        $query = $sql->select()
            ->from(["ea"  => $this->getTable("eav/attribute")], ["attribute_id", "frontend_label"])
            ->join(["cea" => $this->getTable("catalog/eav_attribute")], "cea.attribute_id = ea.attribute_id", [])
            ->join(["et"  => $this->getTable("eav/entity_type")], "et.entity_type_id = ea.entity_type_id", [])
            ->join(["eo"  => $this->getTable("eav/attribute_option")], "eo.attribute_id = ea.attribute_id", ["option_id"])
            ->join(["eov" => $this->getTable("eav/attribute_option_value")], "eov.option_id = eo.option_id AND eov.store_id = 0", ["value"])
            ->where("et.entity_type_code = ?", Mage_Catalog_Model_Product::ENTITY)
            ->where("ea.frontend_input IN (?)", [ "select", "multiselect" ])
            ->where("cea.is_filterable_in_search <> 0 OR cea.is_filterable <> 0")
            ->order(new Zend_Db_Expr("ea.frontend_label, eov.value ASC"));

        $stmt = $sql->query($query);

        $ret = [];

        foreach($stmt as $row) {
            if( ! array_key_exists($row["attribute_id"], $ret)) {
                $ret[$row["attribute_id"]] = [
                    "frontend_label" => $row["frontend_label"],
                    "attribute_id"   => $row["attribute_id"],
                    "options"        => [],
                ];
            }

            $ret[$row["attribute_id"]]["options"][$row["option_id"]] = [
                "value" => $row["value"],
                "id"    => $row["option_id"],
            ];
        }

        return $ret;
    }
}
