<?php

class Crossroads_DynamicCategories_Block_Adminhtml_Infoblock_Edit_Tab_Form extends Mage_Adminhtml_Block_Widget_Form {
    protected function _prepareForm() {
        $form = new Varien_Data_Form();

        $this->setForm($form);

        $fieldset           = $form->addFieldset( "general", [ "legend" => $this->__("Details") ]);
        $infoblockSingleton = Mage::getSingleton("dynamiccategories/infoblock");

        $this->_addFieldsToFieldset($fieldset, [
            "name" => [
                "label"    => $this->__("Name"),
                "input"    => "text",
                "required" => true,
                "note"     => "Internal name.",
            ],
            "enabled" => [
                "label"    => $this->__("Enabled"),
                "input"    => "select",
                "required" => true,
                "options"  => Mage::helper("dynamiccategories")->getEnabledOptions(),
            ],
            "priority" => [
                "input"    => "text",
                "label"    => $this->__("Priority"),
                "note"     => "If multiple blocks match and have the same number of matching conditions, the one with the highest priority wins.",
                "required" => false,
            ],
            "active_from" => [
                "input"    => "date",
                "label"    => $this->__("Active from"),
                "required" => false,
                "image"    => $this->getSkinUrl("images/grid-cal.gif"),
                "format"   => Mage::app()->getLocale()->getDateTimeFormat(Mage_Core_Model_Locale::FORMAT_TYPE_SHORT),
                "time"     => true,
            ],
            "active_to" => [
                "input"    => "date",
                "label"    => $this->__("Active to"),
                "required" => false,
                "image"    => $this->getSkinUrl("images/grid-cal.gif"),
                "format"   => Mage::app()->getLocale()->getDateTimeFormat(Mage_Core_Model_Locale::FORMAT_TYPE_SHORT),
                "time"     => true,
            ],
        ]);

        $contentFieldset = $form->addFieldset("infoblock_content", [ "legend" => $this->__("Content") ]);

        $this->_addFieldsToFieldset($contentFieldset, [
            "title" => [
                "label"    => $this->__("Title"),
                "input"    => "text",
                "required" => true,
                "note"     => "Title information for the page containing the info block."
            ],
            "heading" => [
                "label"    => $this->__("Heading"),
                "input"    => "text",
                "required" => true,
                "note"     => "Text shown as a heading for the info block.",
            ],
            "meta_title" => [
                "label"    => $this->__("Meta Title"),
                "input"    => "text",
                "required" => false,
                "note"     => "Maximum length 160 characters.",
            ],
            "meta_description" => [
                "label"    => $this->__("Meta Description"),
                "input"    => "text",
                "required" => false,
                "note"     => "Maximum length 160 characters.",
            ],
            "description" => [
                "named"    => "description",
                "label"    => $this->__("Block description"),
                "title"    => $this->__("Block description"),
                "input"    => "editor",
                "wysiwyg"  => true,
                "config"   => Mage::getSingleton("cms/wysiwyg_config")->getConfig(),
                "required" => false,
            ],
        ]);
    }

    protected function _addFieldsToFieldset(Varien_Data_Form_Element_Fieldset $fieldset, $fields) {
        $requestData = new Varien_Object($this->getRequest()->getPost("infoblockData"));

        foreach($fields as $name => $_data) {
            if($requestValue = $requestData->getData($name)) {
                $_data["value"] = $requestValue;
            }

            $_data["name"]  = "infoblockData[$name]";
            $_data["title"] = $_data["label"];

            if(!array_key_exists("value", $_data)) {
                $_data["value"] = $this->_getInfoblock()->getData($name);
            }

            $fieldset->addField($name, $_data["input"], $_data);
        }

        return $this;
    }

    protected function _getInfoblock() {
        if( ! $this->hasData("infoblock")) {
            // Set in controller
            $infoblock = Mage::registry("current_infoblock");

            if (!$infoblock instanceof Crossroads_DynamicCategories_Model_Infoblock) {
                $infoblock = Mage::getModel("dynamiccategories/infoblock");
            }

            $this->setData("infoblock", $infoblock);
        }

        return $this->getData("infoblock");
    }
}
