<?php

class Crossroads_DibsD2_Block_Redirect extends Mage_Core_Block_Template {

    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate('dibsd2/redirect.phtml');
        $this->setIsTest(Mage::helper('DibsD2')->getIsTest());
    }

    public function getFormData()
    {
        $incrementId = $this->getIncrementId();
        $transaction = Mage::getModel('sales/order_payment_transaction')
                ->getCollection()
                ->addAttributeToFilter('txn_id', array('eq' => $incrementId))
                ->getFirstItem();

        if (Mage::helper('DibsD2')->getIsTest()) {
            Mage::log(
                    "getFormData():\n" . print_r($transaction->getAdditionalInformation(), true),
                    LOG_DEBUG,
                    Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                    true
            );
        }
        
        return $transaction->getAdditionalInformation(Crossroads_DibsD2_Helper_Data::FIELD_FORM_DATA);
    }

}
