<?php

class Crossroads_DibsD2_Model_Payment extends Crossroads_API_Payment_Abstract {

    /**
     * Instructs the client to take the data found in `fields` in the response
     * and POST that data to the URL found in `url`.
     */
    const ACTION_SUBMIT_FORM_DATA = "SUBMIT_FORM_DATA";

    public function getCode()
    {
        return Crossroads_DibsD2_Helper_Data::PAYMENT_METHOD_CODE;
    }

    public function getControllerClassName()
    {
        return "Crossroads_DibsD2_Controller_Payment";
    }

    public function isQuoteInvalid($_quote)
    {
        return false;
    }

    public function getOrderPaymentData($order)
    {
        switch($order->getStatus()) {
        case Mage_Sales_Model_Order::STATE_PENDING_PAYMENT:
        case Mage_Sales_Model_Order::STATE_PAYMENT_REVIEW:
            $authTxn = $order->getPayment()->getAuthorizationTransaction();

            if( ! $authTxn) {
                throw new Exception(sprintf("Crossroads_DibsD2: Expected order '%s' with status '%s' to have an authorization transaction", $order->getIncrementId(), $order->getStatus()));
            }

            return [
                "action" => self::ACTION_SUBMIT_FORM_DATA,
                "url"    => Crossroads_DibsD2_Helper_API::PAYMENT_URL,
                "fields" => $this->transformCallbacks($order, $authTxn->getAdditionalInformation(Crossroads_DibsD2_Helper_Data::FIELD_FORM_DATA)),
            ];
        default:
            return null;
        }
    }

    /**
     * We need to convert the URLs to be scoped under /api.
     *
     * @param  array
     * @return array
     */
    protected function transformCallbacks($order, $data) {
        $incrementId = $order->getIncrementId();
        $callbackMap = [
            "accepturl"   => "accept",
            "cancelurl"   => "cancel",
            "callbackurl" => "system",
            "notifyurl"   => "system",
        ];

        foreach($callbackMap as $key => $action) {
            $data[$key] = Mage::getUrl("", [
                "_direct"      => $this->getControllerUrl()."/".$action."/incrementid/".urlencode($incrementId),
                "_use_rewrite" => false,
            ]);
        }

        return $data;
    }
}
