<?php

class Crossroads_DibsD2_TestController extends Mage_Core_Controller_Front_Action {

    public function indexAction()
    {
        die('testController::indexAction()');
    }

    // Called by: /dibsd2/test/config[/store_id/<store_id>]
    public function configAction()
    {
        Mage::helper('Integration')->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);

        $params = $this->getRequest()->getParams();
        $storeId = 0;

        if (!empty($params['store_id'])) {
            $storeId = intval($params['store_id']);
        }
        $configData = Mage::helper('DibsD2')->getConfig(null, $storeId);

        echo('<p>Config data:</p><pre>' . print_r($configData, true) . '</pre>');

        echo "<p>getConfig('capturenow', {$storeId}) = " . Mage::helper('DibsD2')->getConfig('capturenow', $storeId) . "</p>";
        echo "<p>getConfig('merchant', {$storeId}) = " . Mage::helper('DibsD2')->getConfig(Crossroads_DibsD2_Helper_Data::CONFIG_PATH_MERCHANT, $storeId) . "</p>";
        echo "<p>getConfig('merchant', {$storeId}, 'SE') = " . Mage::helper('DibsD2')->getConfig(Crossroads_DibsD2_Helper_Data::CONFIG_PATH_MERCHANT, $storeId, 'SE') . "</p>";
    }

    // Called by: /dibsd2/test/additionalinformation[/increment_id/<increment_id>]|[/order_id/<order_id>]
    public function additionalinformationAction()
    {
        Mage::helper('Integration')->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);

        $params = $this->getRequest()->getParams();
        $order = null;

        if (!empty($params['increment_id'])) {
            $order = Mage::getModel('sales/order')->loadByIncrementId($params['increment_id']);
        } elseif (!empty($params['order_id'])) {
            $order = Mage::getModel('sales/order')->load(intval($params['order_id']));
        } else {
            die('<p>Say what?</p>');
        }

        if ($order && $order->getId()) {
            $payment = $order->getPayment();
            $transaction = Mage::helper('DibsD2')->getLastTransaction($payment);
            $data = $transaction->getAdditionalInformation();
            $this->_outputData($data);
        }
    }

    // Called by: /dibsd2/test/checkpaymentrevieworders
    public function checkpaymentreviewordersAction()
    {
        Mage::helper('Integration')->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);

        $model = Mage::getModel('DibsD2/Observer');
        $model->checkPaymentReviewOrders();
    }

    private function _outputData($data)
    {
        header('Content-Type: text/html; charset=utf-8');
        echo '<html>';
        echo '<head>';
        echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
        echo '<title>Testsida</title>';
        echo '</head>';
        echo '<body>';
        echo '<pre>' . print_r($data, true) . '</pre>';
        echo "<p>end of line...</p>";
        echo "</body>";
        echo "</html>";
        die();
    }

}
