<?php

class Crossroads_DibsD2_Block_Info extends Mage_Payment_Block_Info {

    protected function _construct()
    {
        parent::_construct();
        $this->setTemplate('dibsd2/payment_info.phtml');
    }

    protected function _prepareSpecificInformation($transport = null)
    {
        if ($this->_paymentSpecificInformation) {
            return $this->_paymentSpecificInformation;
        }

        $transport = new Varien_Object();
        $transport = parent::_prepareSpecificInformation($transport);

        if (Mage::getDesign()->getArea() === "adminhtml") {
            $helper = Mage::helper('DibsD2');
            $APIHelper = Mage::helper('DibsD2/API');
            $payment = $this->getInfo();
            $haveInfo = false;
            $transportData = array();

            $transaction = $helper->getLastTransaction($payment);
            /*
            Mage::log(
                    "transaction->getAdditionalInformation():\n" . print_r($transaction->getAdditionalInformation(), true),
                    LOG_DEBUG,
                    Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                    true
            );
            */

            if ($transaction) {
                $transactionId = $transaction->getTxnId();
                if (!empty($transactionId)) {
                    $additionalInformation = $transaction->getAdditionalInformation();
                    if (empty($additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CALLBACK_DATA])) {
                        // FIELD_CALLBACK_DATA is empty, no callback is made yet
                        $paymentInformation = $APIHelper->getPaymentInformationByCode('missing_callback');
                        $paymentState = $helper->getTranslatedPaymentStateByCode($paymentInformation['payment_state']);
                        $statusCode = empty($additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_STATUSCODE]) ? '-' : $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_STATUSCODE];
                        $transportData = [
                            $helper->__("Payment state") => $paymentState,
                            $helper->__("Status") => "[{$statusCode}] {$paymentInformation['short']}",
                            $helper->__("Description") => $paymentInformation['description'],
                            $helper->__("Information") => $paymentInformation['extra']
                        ];
                    } else {
                        $statusCode = $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_STATUSCODE];
                        $paymentInformation = $APIHelper->getPaymentInformationByCode($statusCode);
                        $paymentState = $helper->getTranslatedPaymentStateByCode($paymentInformation['payment_state']);
                        $APITransactionId = $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_TRANSACT];
                        $cardNo = $helper->getReadableCardNo(
                                $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CARDPREFIX],
                                $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CARDNOMASK]
                        );

                        $transportData = [
                            $helper->__("Transaction") => !empty($APITransactionId) ? $APITransactionId : $transactionId,
                            $helper->__("Payment state") => $paymentState,
                            $helper->__("Status") => "[{$statusCode}] {$paymentInformation['short']}",
                            $helper->__("Description") => $paymentInformation['description'],
                            $helper->__("Information") => $paymentInformation['extra'],
                        ];
                        if (!empty($additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_ACQUIRER])) {
                            $transportData[$helper->__("Acquirer")] = $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_ACQUIRER];
                        }
                        if (!empty($additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CARDCOUNTRY])) {
                            $transportData[$helper->__("Card country")] = $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CARDCOUNTRY];
                        }
                        if (!empty($additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CARDEXPDATE])) {
                            $transportData[$helper->__("Card expirydate")] = $additionalInformation[Crossroads_DibsD2_Helper_Data::FIELD_CARDEXPDATE];
                        }
                        if (!empty($cardNo)) {
                            $transportData[$helper->__("Card masked")] = $cardNo;
                        }

                    }
                    $haveInfo = true;
                }
            }
            if (!$haveInfo) {
                $paymentInformation = $APIHelper->getPaymentInformationByCode('invalid');
                $paymentState = $helper->getTranslatedPaymentStateByCode($paymentInformation['payment_state']);
                $transportData = [
                    $helper->__("Payment state") => $paymentState,
                    $helper->__("Status") => $paymentInformation['short'],
                    $helper->__("Description") => $paymentInformation['description'],
                    $helper->__("Information") => $paymentInformation['extra']
                ];
            }

            if (empty($transportData[$helper->__("Information")])) {
                unset($transportData[$helper->__("Information")]);
            }

            $transport->addData($transportData);

        }

        return $transport;
    }

}
