<?php

class Crossroads_DibsD2_Block_Options_Array extends Mage_Adminhtml_Block_System_Config_Form_Field_Array_Abstract
{
    public function __construct()
    {
        $this->addColumn('country_id', array(
            'label' => Mage::helper('DibsD2')->__('Country code'),
            'style' => 'width:10%',
        ));
        $this->addColumn('merchant', array(
            'label' => Mage::helper('DibsD2')->__('Merchant ID'),
            'style' => 'width:100%',
        ));
        $this->addColumn('account', array(
            'label' => Mage::helper('DibsD2')->__('Account'),
            'style' => 'width:100%',
        ));
        $this->addColumn('api_user', array(
            'label' => Mage::helper('DibsD2')->__('API Username'),
            'style' => 'width:100%',
        ));
        $this->addColumn('api_password', array(
            'label' => Mage::helper('DibsD2')->__('API Password'),
            'style' => 'width:100%',
        ));
        $this->addColumn('md5key1', array(
            'label' => Mage::helper('DibsD2')->__('MD5 key 1'),
            'style' => 'width:100%',
        ));
        $this->addColumn('md5key2', array(
            'label' => Mage::helper('DibsD2')->__('MD5 key 2'),
            'style' => 'width:100%',
        ));
        $this->addColumn('decorator', array(
            'label' => Mage::helper('DibsD2')->__('Decorator'),
            'style' => 'width:100%',
        ));
        $this->addColumn('lang', array(
            'label' => Mage::helper('DibsD2')->__('Language'),
            'style' => 'width:100%',
        ));
        $this->addColumn('paytype', array(
            'label' => Mage::helper('DibsD2')->__('Pay type'),
            'style' => 'width:100%',
        ));
        $this->addColumn('avs_address_check', array(
            'label' => Mage::helper('DibsD2')->__('AVS: Require address check'),
            'style' => 'width:100%',
        ));
        $this->addColumn('avs_address_mismatch', array(
            'label' => Mage::helper('DibsD2')->__('AVS: Decline on address mismatch'),
            'style' => 'width:100%',
        ));
        $this->addColumn('avs_address_missing', array(
            'label' => Mage::helper('DibsD2')->__('AVS: Accept on missing address'),
            'style' => 'width:100%',
        ));
        $this->addColumn('avs_zipcode_check', array(
            'label' => Mage::helper('DibsD2')->__('AVS: Require zipcode check'),
            'style' => 'width:100%',
        ));
        $this->addColumn('avs_zipcode_mismatch', array(
            'label' => Mage::helper('DibsD2')->__('AVS: Decline on zipcode mismatch'),
            'style' => 'width:100%',
        ));
        $this->addColumn('avs_zipcode_missing', array(
            'label' => Mage::helper('DibsD2')->__('AVS: Accept on zipcode missing'),
            'style' => 'width:100%',
        ));

        $this->_addAfter = false;
        $this->_addButtonLabel = Mage::helper('DibsD2')->__('Add config');
        parent::__construct();
        $this->setTemplate('dibsd2/array_dropdown.phtml');
    }

    protected function _renderCellTemplate($columnName)
    {
        if (empty($this->_columns[$columnName])) {
            throw new Exception('Wrong column name specified.');
        }
        $inputName  = $this->getElement()->getName() . '[#{_id}][' . $columnName . ']';

        switch ($columnName) {
            case 'lang':
                $rendered = '<select name="'.$inputName.'" style="width:75%;">';
                $rendered .= '<option value="en_UK">English</option>';
                $rendered .= '<option value="sv_SE">Swedish</option>';
                $rendered .= '<option value="nb_NO">Norwegian</option>';
                $rendered .= '<option value="da_DK">Danish</option>';
                $rendered .= '<option value="fi_FI">Finnish</option>';
                $rendered .= '</select>';
                return $rendered;

            case 'decorator':
                $rendered = '<select name="'.$inputName.'" style="width:75%;">';
                $rendered .= '<option value="default">Default</option>';
                $rendered .= '<option value="basal">Basal</option>';
                $rendered .= '<option value="rich">Rich</option>';
                $rendered .= '<option value="responsive">Responsive</option>';
                $rendered .= '<option value="custom">Custom uploaded</option>';
                $rendered .= '</select>';
                return $rendered;

            case 'avs_address_mismatch':
            case 'avs_zipcode_mismatch':
                $rendered = '<select name="'.$inputName.'" style="width:75%;">';
                $rendered .= '<option value="1">Yes</option>';
                $rendered .= '<option value="0">No</option>';
                $rendered .= '</select>';
                return $rendered;

            case 'avs_address_check':
            case 'avs_address_missing':
            case 'avs_zipcode_check':
            case 'avs_zipcode_missing':
                $rendered = '<select name="'.$inputName.'" style="width:75%;">';
                $rendered .= '<option value="0">No</option>';
                $rendered .= '<option value="1">Yes</option>';
                $rendered .= '</select>';
                return $rendered;

            default:
                return parent::_renderCellTemplate($columnName);
        }

    }

}
