<?php

class Crossroads_DibsD2_Controller_Payment extends Crossroads_API_Controller_Payment {

    /**
     * Retrieves orderId from query-parameters.
     *
     * @return string
     */
    protected function getOrderIncrementId() {
        $req = $this->getRequest();

        return $req->getParam("incrementId") ?: $req->getParam("incrementid");
    }

    public function acceptAction()
    {
        $params  = $this->getRequest()->getParams();
        $store   = Mage::app()->getStore();
        $orderId = $this->getOrderIncrementId();

        if (Mage::helper('DibsD2')->getIsTest()) {
            Mage::log(
                    "acceptAction():\n" . print_r($params, true),
                    LOG_DEBUG,
                    Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_RESULTS,
                    true
            );
        }

        $this->_redirectPaymentSuccess($store, $orderId);
    }

    public function cancelAction()
    {
        $params      = $this->getRequest()->getParams();
        $store       = Mage::app()->getStore();
        $incrementId = $this->getOrderIncrementId();

        Mage::log(
                "cancelAction():\n" . print_r($params, true),
                LOG_DEBUG,
                Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_RESULTS,
                true
        );

        // Dibs does no system callback if customer cancels payment, therefore we need to handle cancelation here :-(
        // Why, Dibs, why!!!
        $isOk = true;
        try {
            if (!empty($incrementId)) {
                $order          = Mage::getModel('sales/order')->loadByIncrementId($incrementId);
                $payment        = $order->getPayment();
                $methodInstance = $payment->getMethodInstance();

                $params['statuscode'] = 99; // Fake statuscode since we don't get one.
                $params['transact'] = $order->getId(); // Fake transact since we don't get one.

                $methodInstance->handleCallback($payment, $params, false);
            }
            else {
                Mage::log(
                        "Missing increment_id in cancelCallback",
                        LOG_DEBUG,
                        Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                        true
                );
                $isOk = false;
            }
        } catch (Exception $ex) {
            Mage::logException($ex);
            $isOk = false;
        }

        if ( ! $isOk) {
            $this->_redirectPaymentCancel($store, $incrementId);
        }

        return $this->_redirectPaymentCancel($store, $incrementId);
    }

    public function systemAction()
    {
        $params      = $this->getRequest()->getParams();
        $incrementId = $this->getOrderIncrementId();

        Mage::log(
                "systemAction():\n" . print_r($params, true),
                LOG_DEBUG,
                Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_RESULTS,
                true
        );

        // For test, override values here:
        if (false) {
            $params['statuscode'] = '0';
        }

        $httpStatusCode = 500;
        try {
            if (!empty($incrementId)) {
                $order = Mage::getModel('sales/order')->loadByIncrementId($incrementId);
                $payment = $order->getPayment();
                $methodInstance = $payment->getMethodInstance();
                $methodInstance->handleCallback($payment, $params);
                $httpStatusCode = 204;
            }
            else {
                $httpStatusCode = 400;

                Mage::log(
                        "Missing increment_id in callback",
                        LOG_DEBUG,
                        Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                        true
                );
            }
        } catch (Exception $ex) {
            Mage::log(
                    "systemAction() Exception!:\n" . $ex->getMessage(),
                    LOG_ERR,
                    Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                    true
            );
            Mage::logException($ex);
        }

        $this->getResponse()
            ->clearHeaders()
            ->setHeader('HTTP/1.0', $httpStatusCode, true)
            ->setHeader('Content-Type', 'text/html')
            ->setBody("");
    }

}
