<?php

class Crossroads_DibsD2_CallbackController extends Mage_Core_Controller_Front_Action {

    public function indexAction()
    {
        die('callbackController::indexAction()');
    }

    public function acceptAction()
    {
        $params = $this->getRequest()->getParams();
        if (Mage::helper('DibsD2')->getIsTest()) {
            Mage::log(
                    "acceptAction():\n" . print_r($params, true),
                    LOG_DEBUG,
                    Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_RESULTS,
                    true
            );
        }
        Mage::app()->getFrontController()->getResponse()->setRedirect(
                Mage::app()->getStore()->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_WEB)
                . 'checkout/onepage/success'
        );
    }

    public function cancelAction()
    {
        $params = $this->getRequest()->getParams();
        Mage::log(
                "cancelAction():\n" . print_r($params, true),
                LOG_DEBUG,
                Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_RESULTS,
                true
        );

        // Dibs does no system callback if customer cancels payment, therefore we need to handle cancelation here :-(
        // Why, Dibs, why!!!
        $isOk = true;
        try {
            $incrementId = $params['incrementid'];
            if (!empty($incrementId)) {
                $order = Mage::getModel('sales/order')->loadByIncrementId($incrementId);
                $payment = $order->getPayment();
                $methodInstance = $payment->getMethodInstance();
                $params['statuscode'] = 99; // Fake statuscode since we don't get one.
                $params['transact'] = $order->getId(); // Fake transact since we don't get one.
                $methodInstance->handleCallback($payment, $params, false);
            } else {
                Mage::log(
                        "cancelAction() Missing increment_id in callback!",
                        LOG_ERR,
                        Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                        true
                );
                $isOk = false;
            }
        } catch (Exception $ex) {
            Mage::logException($ex);
            $isOk = false;
        }

        if ($isOk) {
            $this->loadLayout();
            $customBlock = $this->getLayout()->createBlock('DibsD2/Canceled');
            if (!empty($params['incrementid'])) {
                $incrementId = $params['incrementid'];
            } else {
                $incrementId = Mage::getSingleton('checkout/session')->getLastRealOrderId();
            }
            $customBlock->setData('increment_id', $incrementId);
            $this->getLayout()->getBlock('content')->append($customBlock);
            $this->renderLayout();
        } else {
            Mage::app()->getFrontController()->getResponse()->setRedirect(
                Mage::app()->getStore()->getBaseUrl(Mage_Core_Model_Store::URL_TYPE_WEB)
                . 'checkout/onepage/failure'
            );
        }
    }

    public function systemAction()
    {
        $params = $this->getRequest()->getParams();
        Mage::log(
                "systemAction():\n" . print_r($params, true),
                LOG_DEBUG,
                Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_RESULTS,
                true
        );

        // For test, override values here:
        if (false) {
            $params['statuscode'] = '0';
        }

        $httpStatusCode = 500;
        try {
            $incrementId = $params['incrementid'];
            if (!empty($incrementId)) {
                $order = Mage::getModel('sales/order')->loadByIncrementId($incrementId);
                $payment = $order->getPayment();
                $methodInstance = $payment->getMethodInstance();
                $methodInstance->handleCallback($payment, $params);
                $httpStatusCode = 204;
            } else {
                $httpStatusCode = 400;
                Mage::log(
                        "systemAction() Missing increment_id in callback!",
                        LOG_ERR,
                        Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                        true
                );
            }
        } catch (Exception $ex) {
            Mage::log(
                    "systemAction() Exception!:\n" . $ex->getMessage(),
                    LOG_ERR,
                    Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL,
                    true
            );
            Mage::logException($ex);
        }
        $this->getResponse()
                ->clearHeaders()
                ->setHeader('HTTP/1.0', $httpStatusCode, true)
                ->setHeader('Content-Type', 'text/html')
                ->setBody("");
    }

}
