<?php

class Crossroads_DibsD2_Model_Observer extends Mage_Core_Model_Abstract {

    public function checkPaymentReviewOrders()
    {
        $startTime = time();
        $timestamp = date('Y-m-d H:i:s', $startTime);
        $lockName = 'dibsd2_payment_review_orders';
        $haveLock = 0;
        $integrationHelper = Mage::helper('Integration');

        Mage::log("DibsD2::checkPaymentReviewOrders() Started at {$timestamp}", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);

        try {
            if ($integrationHelper->getLock($lockName)) {
                $haveLock = 1;
                if ($integrationHelper->checkLockDate($lockName) === true) {
                    $haveLock = 2;
                    $limitByStore = ''; // Changed later if not active in whole instance

                    // Check if cron job is active in whole instance
                    $globallyActive = Mage::getStoreConfig('payment/DibsD2/auto_check_payment_review', 0) ? true : false;
                    if (!$globallyActive) {
                        // If not, try to find if cron job is active in any website or store
                        $storeIds = [];
                        $sqlQuery1 = "
                            SELECT
                                DISTINCT(IF(s.store_id IS NOT NULL, s.store_id, IF(d.scope = 'stores', d.scope_id, 0))) AS store_id
                            FROM core_config_data d
                            LEFT JOIN core_store s ON s.website_id = d.scope_id AND d.scope = 'websites'
                            WHERE
                                d.path = 'payment/DibsD2/auto_check_payment_review'
                                AND d.scope_id > 0
                        ";
                        $storeList = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchAll($sqlQuery1);
                        if (!empty($storeList)) {
                            // Build list of stores where cron job is active
                            foreach ($storeList as $storeRow) {
                                if (!empty($storeRow['store_id'])) {
                                    $storeIds[] = intval($storeRow['store_id']);
                                }
                            }
                        }
                        if (!empty($storeIds)) {
                            $storeStr = implode(',', $storeIds);
                            // Limit list of orders to orders placed in specified stores
                            $limitByStore = "AND o.store_id IN ({$storeStr})";
                        }
                    }

                    $sqlQuery2 = "
                        SELECT
                            o.increment_id,
                            o.entity_id,
                            o.created_at,
                            o.store_id,
                            CAST(IF(o.created_at < :oldDate, 1, 0) AS UNSIGNED) AS is_old
                        FROM sales_flat_order o
                        JOIN sales_flat_order_payment p ON p.parent_id = o.entity_id
                        WHERE
                            o.created_at < :newDate
                            AND o.`status` = 'payment_review'
                            AND p.method = 'DibsD2'
                            {$limitByStore}
                        ORDER BY o.created_at
                    ";
                    $params2 = [
                        'newDate' => date('Y-m-d H:i:s', strtotime('-4 hours')),
                        'oldDate' => date('Y-m-d H:i:s', strtotime('-1 week'))
                    ];

                    $orderList = Mage::getSingleton('core/resource')->getConnection('core_read')->fetchAll($sqlQuery2, $params2);
                    if (!empty($orderList)) {
                        $orderCount = count($orderList);
                        Mage::log("DibsD2::checkPaymentReviewOrders() Found {$orderCount} orders with 'status' payment_review to process...", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
                        foreach ($orderList as $orderRow) {
                            $order = Mage::getModel('sales/order')->load(intval($orderRow['entity_id']));
                            if (!empty($order) && $order->getIncrementId() == $orderRow['increment_id']) {
                                $payment = $order->getPayment();
                                $methodInstance = $payment->getMethodInstance();
                                $transaction = Mage::helper('DibsD2')->getLastTransaction($payment);
                                if ($orderRow['is_old']) {
                                    // Order is old, cancel it!
                                    Mage::log("DibsD2::checkPaymentReviewOrders() Order {$orderRow['increment_id']} was too old, canceling it.", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
                                    $fakeParams = [
                                        'statuscode' => 98,
                                        'transact' => $order->getId(),
                                        'message' => 'Order has been waiting for payment too long, canceling it.'
                                    ];
                                    $methodInstance->handleCallback($payment, $fakeParams, false);
                                    Mage::helper('Integration')->sendAdminEmail(
                                            "DibsD2 order {{$orderRow['increment_id']}} canceled.", "Order {$orderRow['increment_id']} has been waiting for payment too long, canceling it.\n" .
                                            "It was placed at {$orderRow['created_at']}.\n\n" .
                                            "Transaction info: " . print_r($transaction->getAdditionalInformation(), true), true
                                    );
                                } else {
                                    // Check with dibs if order is paid or not
                                    Mage::log("DibsD2::checkPaymentReviewOrders() Checking payment status for order {$orderRow['increment_id']}.", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
                                    $methodInstance->updateOrderAccordingToInfoFromDibs($payment, $transaction->getTxnId());
                                }
                                usleep(250000); // Wait for a while to not choke db
                            } else {
                                Mage::log("DibsD2::checkPaymentReviewOrders() Unable to load order {$orderRow['increment_id']}.", LOG_ERR, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
                            }
                        }
                    } else {
                        Mage::log("DibsD2::checkPaymentReviewOrders() Found no orders with 'status' payment_review to process.", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
                    }

                    $integrationHelper->clearLockDate($lockName);
                } else {
                    Mage::log("DibsD2::checkPaymentReviewOrders() Already running.", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
                }
                $integrationHelper->releaseLock($lockName);
            } else {
                Mage::log("DibsD2::checkPaymentReviewOrders() Already running.", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
            }

        } catch (Exception $exception) {
            // Just catch errors and log them, perhaps email them too?
            // todo: email error?
            Mage::log("DibsD2::checkPaymentReviewOrders() Exception!", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);
            Mage::logException($exception);
            if($haveLock > 1) {
                $integrationHelper->clearLockDate($lockName);
            }
            if($haveLock > 0) {
                $integrationHelper->releaseLock($lockName);
            }
        }

        $runningTime = time() - $startTime;
        $hh = floor($runningTime / 3600);
        $timeLeft = $runningTime % 3600;
        $mm = floor($timeLeft / 60);
        $ss = $timeLeft % 60;

        Mage::log("DibsD2::checkPaymentReviewOrders() Done, script ran for {$hh} hours, {$mm} minutes and {$ss} seconds.\n", LOG_DEBUG, Crossroads_DibsD2_Helper_Data::LOGGING_FILENAME_NORMAL, true);

        return $this;
    }

}
