<?php

class Crossroads_DibsD2_TestController extends Mage_Core_Controller_Front_Action {

    public function indexAction()
    {
        die('testController::indexAction()');
    }

    // Called by: /dibsd2/test/additionalinformation[/increment_id/<increment_id>]|[/order_id/<order_id>]
    public function additionalinformationAction()
    {
        Mage::helper('Integration')->checkIP();
        Mage::app()->setCurrentStore(Mage_Core_Model_App::ADMIN_STORE_ID);

        $params = $this->getRequest()->getParams();
        $order = null;

        if (!empty($params['increment_id'])) {
            $order = Mage::getModel('sales/order')->loadByIncrementId($params['increment_id']);
        } elseif (!empty($params['order_id'])) {
            $order = Mage::getModel('sales/order')->load(intval($params['order_id']));
        } else {
            die('<p>Say what?</p>');
        }

        if ($order && $order->getId()) {
            $APIModel = Mage::getModel('DibsD2/API');
            $payment = $order->getPayment();
            $transaction = $APIModel->getHelper()->getLastTransaction($payment);
            $data = $transaction->getAdditionalInformation();
            $this->_outputData($data);
        }
    }

    private function _outputData($data)
    {
        header('Content-Type: text/html; charset=utf-8');
        echo '<html>';
        echo '<head>';
        echo '<meta http-equiv="Content-Type" content="text/html; charset=utf-8">';
        echo '<title>Testsida</title>';
        echo '</head>';
        echo '<body>';
        echo '<pre>' . print_r($data, true) . '</pre>';
        echo "<p>end of line...</p>";
        echo "</body>";
        echo "</html>";
        die();
    }

}
