<?php

class Crossroads_DibsD2_Exception extends Exception {

    protected $_extended_info = array();

    public function __construct($message, $code = 0)
    {
        Mage::getSingleton('adminhtml/session')->addError($message);
        parent::__construct($message, $code);
    }    

    public function setExtendedInfo($key, $value)
    {
        if (is_array($key)) {
            $this->_extended_info = $key;
        } else {
            $this->_extended_info[$key] = $value;
        }
    }

    public function __toString()
    {
        $msg = $this->message;
        if (!empty($this->_extended_info)) {
            $msg .= " - extendedInfo:\n" . print_r($this->_extended_info. true);
        }
        return __CLASS__ . ": [{$this->code}]: {$msg}\n";
    }

}
