<?php
class Crossroads_CustomerReview_Adminhtml_ReviewController extends Mage_Adminhtml_Controller_Action
{
    /**
     * Instantiate our grid container block and add to the page content.
     * When accessing this admin index page, we will see a grid of all
     * reviews currently available in our Magento instance, along with
     * a button to add a new one if we wish.
     */
    public function indexAction()
    {
        $reviewBlock = $this->getLayout()
            ->createBlock('crossroads_customerreview_adminhtml/review');

        $this->loadLayout()
            ->_addContent($reviewBlock)
            ->renderLayout();
    }

    public function editAction()
    {
        $review = Mage::getModel('crossroads_customerreview/review');

        if ($reviewId = $this->getRequest()->getParam('id', false)) {
            $review->load($reviewId);

            if ($review->getId() < 1) {
                $this->_getSession()->addError($this->__('This review no longer exists.'));
                return $this->_redirect('crossroads_customerreview_admin/review/index');
            }
        }

        if ($postData = $this->getRequest()->getPost('reviewData')) {
            try {
                $review->addData($postData);
                $review->save();

                $this->_getSession()->addSuccess(
                    $this->__('The review has been saved.')
                );

                // redirect to remove $_POST data from the request
                return $this->_redirect(
                    'crossroads_customerreview_admin/review/edit',
                    ['id' => $review->getId()]
                );
            } catch (Exception $e) {
                Mage::logException($e);
                $this->_getSession()->addError($e->getMessage());
            }
        }


        // Make the current review object available to blocks.
        Mage::register('current_review', $review);

        // Instantiate the form container.
        $reviewEditBlock = $this->getLayout()->createBlock('crossroads_customerreview_adminhtml/review_edit');

        // Add the form container as the only item on this page.
        $this->loadLayout()
            ->_addContent($reviewEditBlock)
            ->renderLayout();
    }

    public function deleteAction()
    {
        $review = Mage::getModel('crossroads_customerreview/review');

        if ($reviewId = $this->getRequest()->getParam('id', false)) {
            $review->load($reviewId);
        }

        if ($review->getId() < 1) {
            $this->_getSession()->addError($this->__('This review no longer exists.'));
            return $this->_redirect('crossroads_customerreview_admin/review/index');
        }

        try {
            $review->delete();

            $this->_getSession()->addSuccess(
                $this->__('The review has been deleted.')
            );
        } catch (Exception $e) {
            Mage::logException($e);
            $this->_getSession()->addError($e->getMessage());
        }

        return $this->_redirect('crossroads_customerreview_admin/review/index');
    }

    protected function _isAllowed()
    {
        $actionName = $this->getRequest()->getActionName();

        switch ($actionName) {
            case 'index':
            case 'edit':
            case 'delete':
                // intentionally no break
            default:
                $adminSession = Mage::getSingleton('admin/session');
                $isAllowed = $adminSession
                    ->isAllowed('crossroads_customerreview/review');
                break;
        }

        return $isAllowed;
    }
}
