# Crossroads Customer Review

A module that allows customer reviews

## Requirements

* [Composer](https://getcomposer.org/download/)
* Magento 1.9.3.2 or greater

## Composer.json

Add the following to your `composer.json`:

```
{
	"name": "Your project name",
	"description": "Your project description",
	"require": {
		"Crossroads_CustomerReview": "dev-master",
		"magento-hackathon/magento-composer-installer": "*"
	},
	"repositories": [
		{
			"type": "vcs",
			"url":  "git@groot.crossroads.se:modules/Crossroads_CustomerReview.git"
		}
	],
	"extra": {
		"magento-root-dir":      ".",
		"auto-append-gitignore": true
	}
}
```

## Development

When this module is installed in a project Composer clones the git reposiotry into `vendor/Crossroads_CustomerReview`. It will then create hard-links according to the `extra.map` specification inside of `composer.json` of the `Crossroads_CustomerReview` package.

To modify and develop the `Crossroads_CustomerReview` module, modify files inside of `vendor/Crossroads_CustomerReview` instead of `app/code/local/Crossroads/Crossroads_CustomerReview`. Then commit and push like normal inside of `vendor/Crossroads_CustomerReview`.

## Configuration

Magento needs to allow symlinked templates if Composer is installing modules through symlinks
(this is the default, see [magento-composer-installer Deploy documentation](https://github.com/Cotya/magento-composer-installer/blob/3.0/doc/Deploy.md)).
In Magento Admin set `System` -> `Configuration` -> `Advanced` -> `Developer` -> `Template Settings`
-> `Allow Symlinks` to Yes.

## Troubleshooting

* Some files got messed up and a reinstall of the module is required:

  ```
  composer run-script post-install-cmd -vvv -- --redeploy
  ```
