<?php
class Crossroads_CustomerReview_Block_Adminhtml_Review_Grid extends Mage_Adminhtml_Block_Widget_Grid
{
    protected function _prepareCollection()
    {
        $collection = Mage::getResourceModel('crossroads_customerreview/review_collection');
        $this->setCollection($collection);

        return parent::_prepareCollection();
    }

    public function getRowUrl($row)
    {
      return $this->getUrl( 'crossroads_customerreview_admin/review/edit', [ 'id' => $row->getId() ]);
    }

    protected function _prepareColumns()
    {
        $this->addColumn('entity_id', [
            'header' => $this->_getHelper()->__('ID'),
            'type'   => 'text',
            'width'  => '70',
            'index'  => 'entity_id',
        ]);

        $this->addColumn('created_at', [
            'header' => $this->_getHelper()->__('Created'),
            'type'   => 'datetime',
            'width'  => '200',
            'index'  => 'created_at',
        ]);

        $this->addColumn('updated_at', [
            'header' => $this->_getHelper()->__('Updated'),
            'type'   => 'datetime',
            'width'  => '200',
            'index'  => 'updated_at',
        ]);

        $this->addColumn('customer_id', [
          'header' => $this->_getHelper()->__('Customer ID'),
          'type'   => 'text',
          'width'  => '100',
          'index'  => 'customer_id',
        ]);

        $this->addColumn('customer_email', [
          'header'   => $this->_getHelper()->__('Customer Email'),
          'type'     => 'text',
          'width'    => '250',
          'index'    => 'customer_id',
          'renderer' => 'Crossroads_CustomerReview_Block_Adminhtml_Review_Renderer_CustomerEmail',
        ]);

        $this->addColumn('customer_company', [
          'header'    => $this->_getHelper()->__('Customer Company'),
          'type'      => 'text',
          'width'     => '200',
          'index'     => 'customer_id',
          'renderer'  => 'Crossroads_CustomerReview_Block_Adminhtml_Review_Renderer_CustomerCompany',
        ]);

        $this->addColumn('feedback', [
            'header' => $this->_getHelper()->__('Feedback'),
            'type'   => 'textarea',
            'index'  => 'feedback',
        ]);

        $this->addColumn('rating', [
            'header'    => $this->_getHelper()->__('Rating'),
            'type'      => 'text',
            'width'     => '60',
            'index'     => 'rating',
            'renderer'  => 'Crossroads_CustomerReview_Block_Adminhtml_Review_Renderer_Rating',
        ]);

        $reviewSingleton = Mage::getSingleton('crossroads_customerreview/review');

        $this->addColumn('status', [
            'header'  => $this->_getHelper()->__('Status'),
            'type'    => 'options',
            'index'   => 'status',
            'width'   => '70',
            'options' => $reviewSingleton->getAvailableStatuses()
        ]);

        $this->addColumn('action', [
            'header'  => $this->_getHelper()->__('Action'),
            'width'   => '50px',
            'type'    => 'action',
            'actions' => [
                [
                    'caption' => $this->_getHelper()->__('Edit'),
                    'url' => [
                        'base' => 'crossroads_customerreview_admin/review/edit',
                    ],
                    'field' => 'id'
                ],
            ],
            'filter'   => false,
            'sortable' => false,
            'index'    => 'entity_id',
        ]);

        return parent::_prepareColumns();
    }

    protected function _getHelper()
    {
        return Mage::helper('crossroads_customerreview');
    }
}
