<?php

$this->startSetup();

$table = new Varien_Db_Ddl_Table();

$table->setName($this->getTable('crossroads_customerreview/review'));

$table->addColumn(
    'entity_id',
    Varien_Db_Ddl_Table::TYPE_INTEGER,
    10,
    [
        'auto_increment' => true,
        'unsigned' => true,
        'nullable'=> false,
        'primary' => true
    ]
);
$table->addColumn(
    'created_at',
    Varien_Db_Ddl_Table::TYPE_DATETIME,
    null,
    [
        'nullable' => false,
    ]
);
$table->addColumn(
    'updated_at',
    Varien_Db_Ddl_Table::TYPE_DATETIME,
    null,
    [
        'nullable' => false,
    ]
);
$table->addColumn(
    'rating',
    Varien_Db_Ddl_Table::TYPE_INTEGER,
    255,
    [
        'nullable' => true,
    ]
);
$table->addColumn(
    'feedback',
    Varien_Db_Ddl_Table::TYPE_TEXT,
    [
        'nullable' => true,
    ]
);
$table->addColumn(
    'status',
    Varien_Db_Ddl_Table::TYPE_BOOLEAN,
    null,
    [
        'nullable' => false,
    ]
);
$table->addColumn(
    'customer_id',
    Varien_Db_Ddl_Table::TYPE_INTEGER,
    255,
    [
        'nullable' => true,
    ]
);

$table->setOption('type', 'InnoDB');
$table->setOption('charset', 'utf8');


$this->getConnection()->createTable($table);

$this->endSetup();
