<?php

class Crossroads_CustomerReview_ReviewAccessController extends Mage_Core_Controller_Front_Action {
    /**
     * @api {get} /reviewaccess/
     * @apiName available
     * @apiGroup CustomerReview
     *
     * @apiSuccess {Boolean} available
     */
    public function indexAction() {
        if($this->getRequest()->getMethod() !== "GET") {
            return $this->getResponse()
                ->setHttpResponseCode(405);
        }

        $customer = Mage::getSingleton('customer/session')->getCustomer();

        if (!Mage::getSingleton('customer/session')->isLoggedIn()) {
            return $this->getResponse()->setHttpResponseCode(405);
        }

        $canReview = Mage::helper('crossroads_customerreview')->canReview($customer->getId());

        return $this->getResponse()
            ->setHttpResponseCode(200)
            ->setHeader("Content-Type", "application/json", true)
            ->setBody(json_encode($canReview));
    }
}
