<?php
class Crossroads_CustomerReview_Model_Resource_Review_Collection extends Mage_Core_Model_Resource_Db_Collection_Abstract
{
    protected function _construct()
    {
        parent::_construct();

        $this->_init(
            'crossroads_customerreview/review',
            'crossroads_customerreview/review'
        );
    }

    public function joinCustomer()
    {
        $res  = Mage::getResourceModel("core/resource");
        $attr = Mage::getSingleton("eav/config")->getAttribute("customer", "company");

        $this->getSelect()
            ->joinLeft([ 'cc' => $res->getValueTable('customer/entity', 'varchar')],
            sprintf('main_table.customer_id = cc.entity_id AND cc.attribute_id = %d', $attr->getAttributeId()), [
                'company' => 'value'
            ]);

        return $this;
    }
}
