<?php
class Crossroads_CustomerReview_Block_Adminhtml_Review_Edit_Form extends Mage_Adminhtml_Block_Widget_Form
{
    protected function _prepareForm()
    {
        $form = new Varien_Data_Form([
            'id' => 'edit_form',
            'action' => $this->getUrl(
                'crossroads_customerreview_admin/review/edit',
                [
                    '_current' => true,
                    'continue' => 0,
                ]
            ),
            'method' => 'post'
        ]);
        $form->setUseContainer(true);
        $this->setForm($form);

        $fieldset = $form->addFieldset(
            'general',
            [
                'legend' => $this->__('Review Details')
            ]
        );

        $reviewSingleton = Mage::getSingleton('crossroads_customerreview/review');

        $this->_addFieldsToFieldset($fieldset, [
            'rating' => [
                'label'    => $this->__('Rating'),
                'input'    => 'text',
                'required' => true,
            ],
            'feedback'     => [
                'label'    => $this->__('Feedback'),
                'input'    => 'text',
                'required' => false,
            ],
            'customer_id'  => [
                'label'    => $this->__('Customer ID'),
                'input'    => 'text',
                'required' => true,
            ],
            'status' => [
                'label'    => $this->__('Status'),
                'input'    => 'select',
                'required' => true,
                'options'  => $reviewSingleton->getAvailableStatuses(),
            ],
        ]);

        return $this;
    }

    protected function _addFieldsToFieldset(Varien_Data_Form_Element_Fieldset $fieldset, $fields)
    {
        $requestData = new Varien_Object($this->getRequest()->getPost('reviewData'));

        foreach ($fields as $name => $_data) {
            if ($requestValue = $requestData->getData($name)) {
                $_data['value'] = $requestValue;
            }

            $_data['name'] = "reviewData[$name]";
            $_data['title'] = $_data['label'];

            if (!array_key_exists('value', $_data)) {
                $_data['value'] = $this->_getReview()->getData($name);
            }

            $fieldset->addField($name, $_data['input'], $_data);
        }

        return $this;
    }

    /**
     * Retrieve the existing review for pre-populating the form fields.
     * For a new review entry, this will return an empty review object.
     */
    protected function _getReview()
    {
        if (!$this->hasData('review')) {
            $review = Mage::registry('current_review');

            if (!$review instanceof Crossroads_CustomerReview_Model_Review) {
                $review = Mage::getModel('crossroads_customerreview/review');
            }

            $this->setData('review', $review);
        }

        return $this->getData('review');
    }
}
