<?php
class Crossroads_CustomerReview_ReviewController extends Crossroads_API_Controller_Resource
{
    /**
     * @api {get} /review Fetch a list of all reviews
     * @apiName getReviews
     * @apiGroup CustomerReview
     *
     * @apiSuccess {Integer} id
     * @apiSuccess {String} created_at
     * @apiSuccess {String} updated_at
     * @apiSuccess {Integer} rating
     * @apiSuccess {String} feedback
     * @apiSuccess {Integer} status
     * @apiSuccess {String} firstname
     * @apiSuccess {Integer} customer_id
     */
    public function getAll() {
        $reviews = Mage::helper('crossroads_customerreview')->getAll();

        return [200, $reviews];
    }

    public function getItem($id) {
        return [404];
    }

  /**
     * @api {post} /review Submit a review
     * @apiName submitReview
     * @apiGroup Review
     *
     * @apiParam {Integer} rating
     * @apiParam {String} feedback
     *
     * @apiSuccess {Integer} id
     */
    public function createItem() {
        $rating   = $this->getRequest()->getQuery("rating");
        $feedback  = $this->getRequest()->getQuery("feedback");

        $customer = Mage::getSingleton('customer/session')->getCustomer();

        if (!Mage::getSingleton('customer/session')->isLoggedIn()) {
            return [405];
        }

        $canReview = Mage::helper('crossroads_customerreview')->canReview($customer->getId());

        if (!$canReview) {
            return [405];
        }

        $review = Mage::getModel('crossroads_customerreview/review')
            ->setCustomerId($customer ? $customer->getId() : null)
            ->setRating($rating)
            ->setFeedback($feedback)
            ->setState('0')
            ->save();

        return [200, (int)$review->getId()];
    }

  /**
     * @api {put} /review/:id Update a review
     * @apiName submitReview
     * @apiGroup Review
     *
     * @apiParam {Integer} rating
     * @apiParam {String} feedback
     *
     * @apiSuccess {Integer} id
     */
    public function replaceItem($id) {
        $params    = $this->requestData();
        $customer  = Mage::getSingleton('customer/session')->getCustomer();
        $review    = Mage::getModel('crossroads_customerreview/review')->load($id);

        if (!Mage::getSingleton('customer/session')->isLoggedIn() || !$review || $review->getCustomerId() !== $customer->getId()) {
            return [405];
        }

        if (!empty($params['rating'])) {
            $review->setRating($params['rating']);
        }
        if (!empty($params['feedback'])) {
            $review->setFeedback($params['feedback']);
        }

        $review->save();

        return [200, (int)$review->getId()];
    }

}
