<?php
class Crossroads_CustomerReview_Model_Review extends Mage_Core_Model_Abstract
{
    const STATUS_DISABLED = '0';
    const STATUS_ENABLED  = '1';

    protected function _construct()
    {
        $this->_init('crossroads_customerreview/review');
    }

    public function getAvailableStatuses()
    {
        return [
            self::STATUS_DISABLED => Mage::helper('crossroads_customerreview')->__('Disabled'),
            self::STATUS_ENABLED  => Mage::helper('crossroads_customerreview')->__('Enabled'),
        ];
    }

    public function getCustomer()
    {
        try {
            $customer = Mage::getModel('customer/customer')->load($this->getCustomerId());
            return $customer;
        } catch (Exception $e) {
            throw new Exception("There is no customer with id: " . $this->getCustomerId());
        }
    }

    protected function _beforeSave()
    {
        parent::_beforeSave();

        $this->_updateTimestamps();
        $this->_prepareUrlKey();

        return $this;
    }

    protected function _updateTimestamps()
    {
        $timestamp = now();

        $this->setUpdatedAt($timestamp);

        if ($this->isObjectNew()) {
            $this->setCreatedAt($timestamp);
        }

        return $this;
    }

    protected function _prepareUrlKey()
    {
        return $this;
    }
}
