<?php

class Crossroads_CustomerReview_Helper_Data extends Mage_Core_Helper_Abstract
{
    public function getAll() {
        $reviews = Mage::getModel('crossroads_customerreview/review')
            ->getCollection()
            ->joinCustomer()
            ->addFieldToFilter('status', '1');


        return array_map(function($review) {
            return $this->prepareReview($review);
        }, $reviews->getData());
    }

    public function getItem($id) {
        $review = Mage::getModel('crossroads_customerreview/review')->load($id);

        if(!$id || !$review->getId()) {
            return null;
        }

        return $this->prepareReview($review);
    }

    public function prepareReview($review) {
        return [
            'id'          => (int)$review['entity_id'],
            'created_at'  => $review['created_at'],
            'updated_at'  => $review['updated_at'],
            'rating'      => (int)$review['rating'],
            'feedback'    => $review['feedback'],
            'status'      => $review['status'],
            'customer_id' => (int)$review['customer_id'],
            'company'     => $review['company'],
        ];
    }

    public function canReview($customerId) {
        $reviews = Mage::getModel('crossroads_customerreview/review')
            ->getCollection()
            ->joinCustomer()
            ->getData();

        return !count(array_filter($reviews, function($x) use ($customerId) {
            return (int)$x['customer_id'] === (int)$customerId;
        }));
    }
}
